/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.layer.MessagingLayerTest;
import org.lsst.ccs.startup.BootUtils;

@RunWith(value=Parameterized.class)
public class StartupWithHardwareProblemsTest
extends CcsTestCaseTemplate {
    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return MessagingLayerTest.getTransportProtocols();
    }

    public StartupWithHardwareProblemsTest(String transport) {
        super(transport);
    }

    @Test
    public void testStopAndWaitFail() throws Exception {
        Agent a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.start();
        BootUtils.LocalBootObject bootObject = new BootUtils.LocalBootObject("hardwareProblems");
        Subsystem s = bootObject.getSubsystem();
        s.start();
        s.switchToEngineeringMode();
        s.addClearAlertHandler(new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        });
        Thread.sleep(500L);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        Assert.assertTrue((boolean)s.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)s.isInState((Enum)PhaseState.INITIALIZING));
        cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems/hc1", "repairHardware"), 1000L);
        cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "completeInitialization"), 1000L);
        Assert.assertTrue((boolean)s.isInState((Enum)OperationalState.ENGINEERING_OK));
        Assert.assertTrue((boolean)s.isInState((Enum)PhaseState.OPERATIONAL));
        Object nShuts = cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "getShuts"), 1000L);
        Assert.assertTrue(((Integer)nShuts == 0 ? 1 : 0) != 0);
        try {
            cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "shutdown"), 1000L);
            Assert.assertTrue((boolean)false);
        }
        catch (CommandInvocationException commandInvocationException) {
            // empty catch block
        }
        cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems/hc1/hc1A", "stopHardware"), 1000L);
        cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "stop"), 1000L);
        boolean success = (Boolean)cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "switchToEngineeringMode"), 100L);
        Assert.assertFalse((boolean)success);
        Assert.assertTrue((boolean)s.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        cmu.sendSynchronousCommand(new CommandRequest("hardwareProblems", "clearAllAlerts"), 1000L);
        Assert.assertTrue((s.isInState((Enum)OperationalState.ENGINEERING_OK) && s.isInState((Enum)AlertState.NOMINAL) ? 1 : 0) != 0);
        s.shutdown();
        a.shutdown();
    }
}

