/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.framework.TracerHardwareController;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.layer.MessagingLayerTest;
import org.lsst.ccs.startup.BootUtils;

@RunWith(value=Parameterized.class)
public class StartupOkTest
extends CcsTestCaseTemplate {
    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return MessagingLayerTest.getTransportProtocols();
    }

    public StartupOkTest(String transport) {
        super(transport);
    }

    @Test
    public void testStopAndWaitFail() throws Exception {
        Agent a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.start();
        BootUtils.LocalBootObject bootObject = new BootUtils.LocalBootObject("startupOk");
        Subsystem s = bootObject.getSubsystem();
        s.start();
        s.switchToEngineeringMode();
        Thread.sleep(500L);
        ArrayList<TracerHardwareController> listOfHC = new ArrayList<TracerHardwareController>();
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc1")));
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc1A")));
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc1B")));
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc2")));
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc2A")));
        listOfHC.add((TracerHardwareController)((Object)bootObject.getRunningObject("hc2B")));
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        Assert.assertTrue((s.isInState((Enum)OperationalState.ENGINEERING_OK) && s.isInState((Enum)AlertState.NOMINAL) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.isInState((Enum)PhaseState.OPERATIONAL));
        for (TracerHardwareController hc : listOfHC) {
            Assert.assertTrue((hc.starts == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.postAction == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.tickStarts == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.checkStarts == 0 ? 1 : 0) != 0);
            if (hc.getName().equals("hc2A") || hc.getName().equals("hc2B")) {
                Assert.assertTrue((hc.checks == 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((hc.checks == 1 ? 1 : 0) != 0);
        }
        s.shutdown();
        a.shutdown();
    }
}

