/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.framework.commands.Thing;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.startup.BootUtils;

public class ModuleWithObserverTest
extends CcsTestCaseTemplate {
    @Test
    public void testBuildNodeWithReference() throws Exception {
        Agent a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.start();
        Subsystem s = null;
        try {
            s = new BootUtils.LocalBootObject("moduleWithObserver").getSubsystem();
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
        }
        s.start();
        s.switchToEngineeringMode();
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        while (!a.getMessagingAccess().getAgentPresenceManager().agentExists(s.getName())) {
            Thread.sleep(10L);
        }
        Thing thing = new Thing("hello", -1, 0.01, new BigDecimal(0.01));
        cmu.sendSynchronousCommand(new CommandRequest(s.getName(), "sendObjectToObservers", new Object[]{thing}), 100L);
        Thing observerObj = (Thing)cmu.sendSynchronousCommand(new CommandRequest(s.getName() + "/observer", "showUpdated"), 100L);
        Assert.assertNotNull((Object)observerObj);
        Assert.assertTrue((boolean)observerObj.equals((Object)thing));
        s.shutdown();
        a.shutdown();
    }
}

