/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.SimpleConfigurableModule;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationLoadingWithCategoriesTest
extends CcsTestCaseTemplate {
    private static final String descPath = "simulationWithCategories";

    @Before
    public void init() {
        InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testConfigurationOperationSequence() throws Exception {
        InMemoryWriterProvider writerProvider = InMemoryWriterProvider.getInstance();
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        String subName = s.getName();
        String tagName = s.getTag();
        s.start();
        SimpleConfigurableModule mainModule = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", "0");
        mainModule.change("confVal1", "1");
        mainModule.change("confVal2", "2");
        s.saveAllChanges();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        Properties props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)tagName, (String)""));
        Assert.assertEquals((String)"default properties file size : ", (long)0L, (long)props.size());
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)tagName, (String)"catA"));
        Assert.assertEquals((String)"catA: properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)tagName, (String)"catB"));
        Assert.assertEquals((String)"catB: properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        s.shutdown();
        System.out.println("Restart subsystem");
        s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        mainModule = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        s.start();
        Thread.sleep(200L);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "3");
        s.saveChangesForCategoriesAs(new String[]{"D3", "catA:A1", "catB:B2"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"D3", (String)tagName, (String)""));
        Assert.assertEquals((String)"D3 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"A1", (String)tagName, (String)"catA"));
        Assert.assertEquals((String)"catA:A1 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"B2", (String)tagName, (String)"catB"));
        Assert.assertEquals((String)"catB:B2 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2}, (int[])mainModule.getConfValues());
        mainModule.change("confVal2", "0");
        s.saveChangesForCategoriesAs(new String[]{"catB:B0"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"B0", (String)tagName, (String)"catB"));
        Assert.assertEquals((String)"catB:B0 properties file size : ", (long)0L, (long)props.size());
        Assert.assertArrayEquals((int[])new int[]{3, 1, 0}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "7");
        s.saveAllChanges();
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"D3", (String)tagName, (String)""));
        Assert.assertEquals((String)"D3 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"7", (Object)props.getProperty("main//confVal0"));
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "0");
        mainModule.change("confVal1", "4");
        mainModule.change("confVal2", "2");
        s.saveChangesForCategoriesAs(new String[]{"D0", "catA:A4", "catB:B2"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"D0", (String)tagName, (String)""));
        Assert.assertEquals((String)"D0 properties file size : ", (long)0L, (long)props.size());
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"A4", (String)tagName, (String)"catA"));
        Assert.assertEquals((String)"catA:A4 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"4", (Object)props.getProperty("main//confVal1"));
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"B2", (String)tagName, (String)"catB"));
        Assert.assertEquals((String)"catB:B2 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        Assert.assertArrayEquals((int[])new int[]{0, 4, 2}, (int[])mainModule.getConfValues());
        s.loadConfiguration(new String[]{"D3", "catA:A1", "catB:B0"});
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])mainModule.getConfValues());
        s.loadConfiguration(new String[0]);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        s.shutdown();
    }

    @Test
    public void testErroneousConfigInput() throws Exception {
        try {
            BootUtils.getSubsystemFromFile((String)descPath, (String)"catA:,catB:wrongFile");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("wrongFile"));
        }
    }

    @Test
    public void testErroneousCategoryInput() throws Exception {
        try {
            BootUtils.getSubsystemFromFile((String)descPath, (String)"catA:,catB:,catZ:");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("unexisting category"));
        }
    }

    @Test
    public void testResetConfiguration() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        s.start();
        Configurable mainModule = (Configurable)s.getLookup().getComponentByName("main");
        mainModule.change("confVal0", (Object)10);
        mainModule.change("confVal1", (Object)9);
        mainModule.change("confVal2", (Object)8);
        s.dropChangesForCategories(new String[]{"catA", "catB"});
        s.saveAllChanges();
        Assert.assertArrayEquals((int[])new int[]{10, 0, 0}, (int[])((SimpleConfigurableModule)mainModule).getConfValues());
        s.shutdown();
    }

    @Test
    public void testLoadCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        s.start();
        SimpleConfigurableModule mainModule = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{":D1", "catA:confA1", "catB:confB1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        mainModule.change("confVal1", 7);
        s.saveChangesForCategoriesAs(new String[]{"catA:confA2"});
        Assert.assertArrayEquals((int[])new int[]{10, 7, 8}, (int[])mainModule.getConfValues());
        s.loadCategories(new String[]{"catA:confA1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        s.shutdown();
    }

    @Test
    public void testSaveCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        s.start();
        SimpleConfigurableModule mainModule = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{"confD1", "catB:confB1"});
        try {
            InMemoryWriterProvider.getInstance().getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)s.getTag(), (String)"catA"));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", 9);
        mainModule.change("confVal2", 7);
        Assert.assertArrayEquals((int[])new int[]{9, 9, 7}, (int[])mainModule.getConfValues());
        s.saveChangesForCategories(new String[]{"", "catB"});
        Properties props = InMemoryWriterProvider.getInstance().getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"confD1", (String)s.getTag(), (String)""));
        Assert.assertEquals((String)"confD1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"9", (Object)props.getProperty("main//confVal0"));
        props = InMemoryWriterProvider.getInstance().getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"confB1", (String)s.getTag(), (String)"catB"));
        Assert.assertEquals((String)"catB:confB1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"7", (Object)props.getProperty("main//confVal2"));
        s.saveChangesForCategoriesAs(new String[]{"catA:confA1"});
        props = InMemoryWriterProvider.getInstance().getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"confA1", (String)s.getTag(), (String)"catA"));
        Assert.assertEquals((String)"catA:confA1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"9", (Object)props.getProperty("main//confVal1"));
        s.shutdown();
    }

    @Test
    public void testDropCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        s.start();
        SimpleConfigurableModule mainModule = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{"confD1", "catB:confB1"});
        try {
            Properties props = InMemoryWriterProvider.getInstance().getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)s.getTag(), (String)"catA"));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        s.dropAllChanges();
        Assert.assertArrayEquals((int[])new int[]{10, 0, 8}, (int[])mainModule.getConfValues());
        s.shutdown();
    }
}

