/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.SimpleConfigurableModule;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationLoadingTest
extends CcsTestCaseTemplate {
    private static final String descPath = "configurationC";

    @Before
    public void init() throws IOException {
        InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testConfigurationOperationSequence() throws Exception {
        InMemoryWriterProvider writerProvider = InMemoryWriterProvider.getInstance();
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        SimpleConfigurableModule main = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        s.start();
        Thread.sleep(200L);
        String subName = s.getName();
        s.loadConfiguration(new String[0]);
        main.change("confVal0", "0");
        main.change("confVal1", "1");
        main.change("confVal2", "2");
        int[] configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])configValues);
        s.saveAllChanges();
        Properties props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"", (String)s.getTag()));
        Assert.assertEquals((String)"default properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        s.shutdown();
        s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath).getSubsystem();
        main = (SimpleConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        s.start();
        Thread.sleep(200L);
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])configValues);
        main.change("confVal0", 3);
        s.saveChangesForCategoriesAs(new String[]{"312"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"312", (String)s.getTag()));
        Assert.assertEquals((String)("312 properties file is : \n" + props), (long)3L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2}, (int[])configValues);
        main.change("confVal2", 0);
        s.saveChangesForCategoriesAs(new String[]{"310"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"310", (String)s.getTag()));
        Assert.assertEquals((String)"310 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{3, 1, 0}, (int[])configValues);
        main.change("confVal0", 7);
        s.saveAllChanges();
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"310", (String)s.getTag()));
        Assert.assertEquals((String)"310 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"7", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])configValues);
        main.change("confVal0", 0);
        main.change("confVal1", 4);
        main.change("confVal2", 2);
        s.saveChangesForCategoriesAs(new String[]{"042"});
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)"042", (String)s.getTag()));
        Assert.assertEquals((String)"042 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"4", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{0, 4, 2}, (int[])configValues);
        s.loadConfiguration(new String[]{"310"});
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])configValues);
        s.loadConfiguration(new String[0]);
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])configValues);
        main.change("confVal0", 1);
        main.change("confVal1", 2);
        s.loadConfiguration(new String[0]);
        configValues = main.getConfValues();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])configValues);
        s.shutdown();
    }
}

