/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkChangeConfigurable;
import org.lsst.ccs.config.ConfigureMe;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationBulkChangesTest
extends CcsTestCaseTemplate {
    private static final double doubleVal = 7.65;
    private static final double newVal = 10.0;
    private static NodeModularSubsystem s;
    private static ConfigureMe mainModule;
    private static ConfigureMe childModule;
    private static ConfigureMe predicateSon;
    private static BulkChangeConfigurable withBulkSetting;
    private static BulkChangeConfigurable withFailingBulkSetting;

    @Before
    public void initAgents() throws Exception {
        InMemoryWriterProvider.newInstance();
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationA");
        s.start();
        childModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("son"));
        mainModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("main"));
        predicateSon = (ConfigureMe)((Object)s.getLookup().getComponentByName("predicateSon"));
        withBulkSetting = (BulkChangeConfigurable)((Object)s.getLookup().getComponentByName("withBulkSetting"));
        withFailingBulkSetting = (BulkChangeConfigurable)((Object)s.getLookup().getComponentByName("withFailingBulkSetting"));
    }

    @After
    public void shutdownAgents() throws Exception {
        s.shutdown();
    }

    @Test
    public void testBulkChange() throws Exception {
        withBulkSetting.submitChange("min", 10);
        withBulkSetting.submitChange("max", 7);
        withBulkSetting.submitChange("value", 3.75);
        try {
            s.commitBulkChange();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)withBulkSetting.getMin());
        Assert.assertEquals((long)1000L, (long)withBulkSetting.getMax());
        Assert.assertEquals((double)3.14, (double)withBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)s.getState(ConfigurationState.class));
        withBulkSetting.submitChange("min", 7);
        withBulkSetting.submitChange("max", 10);
        withBulkSetting.submitChange("value", 3.75);
        s.commitBulkChange();
        Assert.assertEquals((long)7L, (long)withBulkSetting.getMin());
        Assert.assertEquals((long)10L, (long)withBulkSetting.getMax());
        Assert.assertEquals((double)3.75, (double)withBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)s.getState(ConfigurationState.class));
        withFailingBulkSetting.submitChange("min", 11);
        withFailingBulkSetting.submitChange("max", 20);
        withFailingBulkSetting.submitChange("value", 5.67);
        try {
            s.commitBulkChange();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)withFailingBulkSetting.getMin());
        Assert.assertEquals((long)1000L, (long)withFailingBulkSetting.getMax());
        Assert.assertEquals((double)3.14, (double)withFailingBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.UNCONFIGURED, (Object)s.getState(ConfigurationState.class));
    }
}

