/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.ConfigureMe;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationATest
extends CcsTestCaseTemplate {
    private static final double doubleVal = 7.65;
    private static final double newVal = 10.0;
    private static NodeModularSubsystem s;
    private static ConfigureMe mainModule;
    private static ConfigureMe childModule;
    private static ConfigureMe predicateSon;

    @Before
    public void initAgents() throws Exception {
        InMemoryWriterProvider.newInstance();
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationA");
        s.start();
        childModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("son"));
        mainModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("main"));
        predicateSon = (ConfigureMe)((Object)s.getLookup().getComponentByName("predicateSon"));
    }

    @After
    public void shutdownAgents() throws Exception {
        s.shutdown();
    }

    @Test
    public void testStaticParameterModification() throws Exception {
        try {
            mainModule.change("info", "newValue");
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("not modifiable at runtime"));
        }
        childModule.change("info", "newValue");
        Assert.assertEquals((String)"child value : ", (Object)"newValue", (Object)childModule.getInfo());
    }

    @Test
    public void testConstraintPredicateCheck() throws Exception {
        predicateSon.change("value", 10.0);
        try {
            predicateSon.change("value", 1.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstraintRangeCheck() throws Exception {
        try {
            childModule.change("max", 4000);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("not in range"));
        }
    }

    @Test
    public void testParameterNotConfigChanger() throws Exception {
        try {
            childModule.change("min", 1000);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("no such config property"));
        }
    }

    @Test
    public void testUserDefinedConfigMethod() {
        try {
            childModule.setMinMax(-1, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            childModule.setMinMax(0, 5000);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        childModule.setMinMax(20, 1500);
        Assert.assertEquals((String)"min : ", (long)20L, (long)childModule.getMin());
        Assert.assertEquals((String)"max : ", (long)1500L, (long)childModule.getMax());
    }

    @Test
    public void testSaveConfigurationA() throws Exception {
        InMemoryWriterProvider writerProvider = InMemoryWriterProvider.getInstance();
        childModule.change("value", 7.65);
        childModule.change("info", "newValue");
        childModule.change("value", 10.0);
        predicateSon.change("value", 10.0);
        childModule.setMinMax(20, 1500);
        s.saveChangesForCategoriesAs(new String[]{"configurationA"});
        String configName = ConfigUtils.baseNameFromNames((String)"configurationA", (String)s.getTag()) + ".properties";
        Properties properties = writerProvider.getConfigurationProperties(configName);
        String propValue = properties.getProperty("son//value");
        String maxValue = properties.getProperty("son//max");
        Assert.assertEquals((String)"son//value : ", (double)10.0, (double)Double.parseDouble(propValue), (double)0.0);
        Assert.assertEquals((String)"son//max : ", (long)1500L, (long)Integer.parseInt(maxValue));
        Assert.assertEquals((String)"modification size : ", (long)5L, (long)properties.size());
    }
}

