/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;

public class BulkChangeConfigurable
extends Module {
    private final String otherKey;
    private String info;
    private int min;
    private int max;
    private double value;
    private final boolean failing;

    public BulkChangeConfigurable(String otherKey, String info, int min, int max, double value, boolean failing) {
        this.otherKey = otherKey;
        this.info = info;
        this.min = min;
        this.max = max;
        this.setValue(value);
        this.failing = failing;
    }

    public String getOtherKey() {
        return this.otherKey;
    }

    public String getInfo() {
        return this.info;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getValue() {
        return this.value;
    }

    @ConfigChanger
    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.value = value;
    }

    @ConfigChanger
    public void setInfo(String info) {
        this.info = info;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        if ((Integer)parametersView.get("min") > (Integer)parametersView.get("max")) {
            throw new IllegalArgumentException("min greater than max");
        }
    }

    public Map<String, Object> setBulkParameter(Map<String, Object> parametersView) {
        if (this.failing) {
            throw new IllegalArgumentException("some user exception thrown in the setBulkParameter method");
        }
        Object obj = parametersView.remove("min");
        if (obj != null) {
            this.min = (Integer)obj;
        }
        if ((obj = parametersView.remove("max")) != null) {
            this.max = (Integer)obj;
        }
        return parametersView;
    }
}

