package org.lsst.ccs.startup;

import java.util.Map;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.groovy.ComponentBuilder;

/**
 * CCS specific ComponentBuilder class. It adds some CCS subsystem
 * specific functionality.
 *
 * All it does at the moment it sets the subsystem name on the top level
 * node, as extracted from the groovy description file.
 *
 * @author The LSST CCS Team
 */
public class CCSBuilder extends ComponentBuilder {

    private final String subsystemName;

    public CCSBuilder(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    @Deprecated
    public CCSBuilder(String subsystemName, String tagName){
        this(subsystemName);
        System.out.println("######### DO NOT USE THIS CONSTRUCTOR. IT IS DEPRECATED.");
        System.out.println("######### USE THE CONSTRUCTOR THAT ONLY TAKES THE SUBSYSTEM NAME");
    }

    @Override
    @Deprecated
    public Object createNode(Object name) {
        Object obj = super.createNode(name);
        if (getCurrentNode() == null) {
            ((DescriptiveNode) obj).setSubsystemName(subsystemName);
        }

        return obj;
    }

    @Override
    public Object createNode(Object name, Object value) {
        Object obj = super.createNode(name, value);
        if (getCurrentNode() == null) {
            ((DescriptiveNode) obj).setSubsystemName(subsystemName);
        }
        return obj;
    }

    @Override
    @Deprecated
    public Object createNode(Object name, Map attributes) {
        Object obj = super.createNode(name, attributes);
        if (getCurrentNode() == null) {
            ((DescriptiveNode) obj).setSubsystemName(subsystemName);
        }
        return obj;
    }

    @Override
    public Object createNode(Object name, Map attributes, Object value) {
        Object obj = super.createNode(name, attributes, value);
        if (getCurrentNode() == null) {
            ((DescriptiveNode) obj).setSubsystemName(subsystemName);
        }
        return obj;
    }

}
