/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.testutils;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.utilities.tracers.Names;

public class CommandSender {
    private final SynchronousCommandAgent syncAgent;
    private final MessagingFactory fac = MessagingFactory.getInstance().forSubsystem(Names.almostUniqueAgentName((String)"cmdSender"));

    public CommandSender() {
        this.syncAgent = new SynchronousCommandAgent(this.fac);
    }

    public <T extends Throwable> Object executeCommand(Class<T> expEx, String dest, String cmdName, Object ... args) {
        try {
            return this.syncAgent.invoke((Command)new ModuleInvokerCommand(dest, cmdName, args), 10000L);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Unexpected exception at command execution : " + cmdName + " : " + ex), (boolean)(expEx == null ? false : expEx.isInstance(ex)));
            return null;
        }
    }

    public Object executeCommand(String dest, String cmdName, Object ... args) {
        return this.executeCommand(null, dest, cmdName, args);
    }

    public <T extends Throwable> Object executeMethod(Class<T> expEx, Configurable c, Method m, Object ... args) {
        try {
            return m.invoke((Object)c, args);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Unexpected exception at command execution : " + m.getName() + " : " + ex), (boolean)(expEx == null ? false : expEx.isInstance(ex)));
            return null;
        }
    }

    public void shutdown() {
        this.fac.shutdownBusAccess();
    }
}

