/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.node_building;

import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.node_building.ModuleWithStructParms;
import org.lsst.ccs.node_building.ModuleWithVarargsParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class NodeBuildingTest {
    private static String simpleParmsAPath = "simpleParmsA.groo";
    private static String mapParmsAPath = "mapParmsA.groo";
    private static String varargsParmsAPath = "varargsParmsA.groo";
    private static String mapParmsAOKProps = "mapParmsA_ok.properties";
    private static String mapParmsAFailProps = "mapParmsA_fail.properties";

    @BeforeClass
    public static void setupClass() {
        BootstrapTestUtils.initializeBootstrap(NodeBuildingTest.class);
        System.setProperty("org.lsst.ccs.resource.path", "org/lsst/ccs/node_building/");
    }

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        BootUtils.LocalBootObject bootObj = new BootUtils.LocalBootObject(simpleParmsAPath);
        Module mainModule = (Module)bootObj.getRunningObject("main");
        LinkedHashMap modules = mainModule.getChildren(Module.class);
        for (Map.Entry entry : modules.entrySet()) {
            Module m = (Module)entry.getValue();
            Assert.assertEquals((String)("main module and " + m + " child should be equal"), (Object)mainModule, (Object)m);
        }
        System.out.println(" component tree:\n" + mainModule.getComponentTree().deepString());
        Configurable topConfigurable = (Configurable)bootObj.getRunningObject("cfTop");
        LinkedHashMap configurables = topConfigurable.getChildren(Configurable.class);
        for (Map.Entry entry : configurables.entrySet()) {
            Configurable c = (Configurable)entry.getValue();
            Assert.assertEquals((String)("top configurable and " + c + " child should be equal"), (Object)topConfigurable, (Object)c);
        }
    }

    @Test
    public void testMapParmsDirectBuild() throws Exception {
        BootUtils.LocalBootObject bootObj = new BootUtils.LocalBootObject(mapParmsAPath);
        ModuleWithMapParms mainModule = (ModuleWithMapParms)((Object)bootObj.getRunningObject("main"));
        ModuleWithStructParms structModule = (ModuleWithStructParms)((Object)bootObj.getRunningObject("structChild"));
        System.out.println(" state of Main " + (Object)((Object)mainModule));
        Assert.assertNotEquals((String)("min should be set " + mainModule.min), (long)0L, (long)mainModule.min);
        Assert.assertNotEquals((String)("max should be set " + mainModule.max), (long)0L, (long)mainModule.max);
        System.out.println(" state of struct" + (Object)((Object)structModule));
        Assert.assertNotEquals((String)("min should be set " + structModule.min), (long)0L, (long)structModule.min);
        Assert.assertNotEquals((String)("max should be set " + structModule.max), (long)0L, (long)structModule.max);
    }

    @Test
    public void testMapParmsPropsOKDirect() {
        try {
            BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)mapParmsAOKProps);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMapParmsPropsFailDirect() {
        try {
            BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)mapParmsAFailProps);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)(ex instanceof IllegalArgumentException));
            return;
        }
        Assert.assertTrue((String)"configuration loading should fail", (boolean)false);
    }

    @Test
    public void testvarargsParmsADirectBuild() {
        Subsystem s = null;
        try {
            s = BootUtils.getSubsystemFromFile((String)varargsParmsAPath);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
            return;
        }
        ModuleWithVarargsParms m1 = (ModuleWithVarargsParms)((Object)((NodeModularSubsystem)s).getLookup().getComponentByName("varargs1"));
        ModuleWithVarargsParms m2 = (ModuleWithVarargsParms)((Object)((NodeModularSubsystem)s).getLookup().getComponentByName("varargs2"));
        Assert.assertEquals((String)"varargs1 length : ", (long)2L, (long)m1.getParmsSize());
        Assert.assertEquals((String)"varargs2 length : ", (long)3L, (long)m2.getIntParmsSize());
    }
}

