/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.config.LocalConfigurationProxy;

public class TestWriterProvider
implements LocalConfigurationProxy.WriterProvider {
    private final Map<String, ByteArrayOutputStream> propertiesMap = new HashMap<String, ByteArrayOutputStream>();

    public PrintWriter getPrintWriter(String configFileName) throws IOException {
        if (!configFileName.endsWith(".properties")) {
            configFileName = String.valueOf(configFileName) + ".properties";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bos);
        this.propertiesMap.put(configFileName, bos);
        return new PrintWriter(writer);
    }

    public String printConfig(String configFileName) {
        if (!configFileName.endsWith(".properties")) {
            configFileName = String.valueOf(configFileName) + ".properties";
        }
        return this.propertiesMap.get(configFileName).toString();
    }

    public Properties getConfigurationProperties(String configFileName) {
        if (!configFileName.endsWith(".properties")) {
            configFileName = String.valueOf(configFileName) + ".properties";
        }
        Properties props = new Properties();
        ByteArrayOutputStream bos = this.propertiesMap.get(configFileName);
        if (bos == null) {
            throw new IllegalArgumentException("Could not find configuration file : " + configFileName);
        }
        byte[] array = bos.toByteArray();
        try {
            props.load(new InputStreamReader(new ByteArrayInputStream(array)));
        }
        catch (IOException iOException) {
            System.err.println("error while reading properties from memory");
        }
        return props;
    }
}

