/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.configuration;

import java.beans.ConstructorProperties;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.utilities.structs.ViewValue;

public class ConfigureMe
extends Module {
    private final String otherKey;
    private String info;
    private int min;
    private int max;
    private double value;

    @ConstructorProperties(value={"otherKey", "info", "min", "max", "value"})
    public ConfigureMe(String otherKey, String info, int min, int max, double value) {
        this.otherKey = otherKey;
        this.info = info;
        this.min = min;
        this.setMax(max);
        this.setValue(value);
    }

    public String getOtherKey() {
        return this.otherKey;
    }

    public String getInfo() {
        return this.info;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getValue() {
        return this.value;
    }

    @ConfigChanger
    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.value = value;
    }

    @ConfigChanger
    public void setInfo(String info) {
        this.info = info;
    }

    @ConfigChanger
    public void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("no negative max");
        }
        if (max > 2048) {
            throw new IllegalArgumentException("no  max > 2048");
        }
        this.max = max;
    }

    @ConfigChanger
    @Command(type=Command.CommandType.CONFIGURATION)
    public synchronized void setMinMax(int min, int max) {
        try {
            ViewValue viewValueMin = this.getCheckedValueFromConfiguration("min", min);
            ViewValue viewValueMax = this.getCheckedValueFromConfiguration("max", max);
            this.min = min;
            this.max = max;
            this.notifyChange("min", viewValueMin.getView());
            this.notifyChange("max", viewValueMax.getView());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException(exc);
        }
    }
}

