/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.configuration;

import java.io.IOException;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.configuration.TestWriterProvider;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.testutils.CommandSender;

public class ConfigurationLoadingTest {
    private static CommandSender commandSender;

    @BeforeClass
    public static void init() throws IOException {
        BootstrapTestUtils.initializeBootstrap(ConfigurationLoadingTest.class);
        System.setProperty("org.lsst.ccs.resource.path", "org/lsst/ccs/configuration/");
        System.setProperty("org.lsst.ccs.transport", "mock:single");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("org.lsst.ccs.testcontext", "true");
        System.setProperty("org.lsst.ccs.sharedJVM", "true");
        System.setProperty("org.lsst.ccs.startInEngineeringMode", "true");
        commandSender = new CommandSender();
    }

    @Test
    public void testConfigurationOperationSequence() throws Exception {
        this.testProcedure1("configurationC.groo");
        this.testProcedure1("simulation");
    }

    public void testProcedure1(String descPath) throws Exception {
        TestWriterProvider writerProvider = new TestWriterProvider();
        NodeModularSubsystem s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath, null, null, (LocalConfigurationProxy.WriterProvider)writerProvider).getSubsystem();
        s.start();
        Thread.sleep(5000L);
        String subName = s.getName();
        commandSender.executeCommand(subName, "loadConfiguration", new Object[0]);
        commandSender.executeCommand(subName, "change", "confVal0", "0");
        commandSender.executeCommand(subName, "change", "confVal1", "1");
        commandSender.executeCommand(subName, "change", "confVal2", "2");
        commandSender.executeCommand(subName, "saveConfiguration", new Object[0]);
        Properties props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)s.getName(), (String)"", (String)s.getTag()));
        Assert.assertEquals((String)"default properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        int[] configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        Assert.assertArrayEquals((int[])nArray, (int[])configValues);
        s.shutdown();
        Thread.sleep(5000L);
        s = (NodeModularSubsystem)new BootUtils.LocalBootObject(descPath, null, null, (LocalConfigurationProxy.WriterProvider)writerProvider).getSubsystem();
        s.start();
        Thread.sleep(5000L);
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        Assert.assertArrayEquals((int[])nArray2, (int[])configValues);
        commandSender.executeCommand(subName, "change", "confVal0", "3");
        commandSender.executeCommand(subName, "saveConfiguration", "312");
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)s.getName(), (String)"312", (String)s.getTag()));
        Assert.assertEquals((String)"312 properties file size : ", (long)3L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2}, (int[])configValues);
        commandSender.executeCommand(subName, "change", "confVal2", "0");
        commandSender.executeCommand(subName, "saveConfiguration", "310");
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)s.getName(), (String)"310", (String)s.getTag()));
        Assert.assertEquals((String)"310 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray3 = new int[3];
        nArray3[0] = 3;
        nArray3[1] = 1;
        Assert.assertArrayEquals((int[])nArray3, (int[])configValues);
        commandSender.executeCommand(subName, "change", "confVal0", "7");
        commandSender.executeCommand(subName, "saveConfiguration", new Object[0]);
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)s.getName(), (String)"310", (String)s.getTag()));
        Assert.assertEquals((String)"310 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"7", (Object)props.getProperty("main//confVal0"));
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray4 = new int[3];
        nArray4[0] = 7;
        nArray4[1] = 1;
        Assert.assertArrayEquals((int[])nArray4, (int[])configValues);
        commandSender.executeCommand(subName, "change", "confVal0", "0");
        commandSender.executeCommand(subName, "change", "confVal1", "4");
        commandSender.executeCommand(subName, "change", "confVal2", "2");
        commandSender.executeCommand(subName, "saveConfiguration", "042");
        props = writerProvider.getConfigurationProperties(ConfigUtils.baseNameFromNames((String)s.getName(), (String)"042", (String)s.getTag()));
        Assert.assertEquals((String)"042 properties file size : ", (long)2L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"4", (Object)props.getProperty("main//confVal1"));
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray5 = new int[3];
        nArray5[1] = 4;
        nArray5[2] = 2;
        Assert.assertArrayEquals((int[])nArray5, (int[])configValues);
        commandSender.executeCommand(subName, "loadConfiguration", "310");
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray6 = new int[3];
        nArray6[0] = 7;
        nArray6[1] = 1;
        Assert.assertArrayEquals((int[])nArray6, (int[])configValues);
        commandSender.executeCommand(subName, "loadConfiguration", new Object[0]);
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = 2;
        Assert.assertArrayEquals((int[])nArray7, (int[])configValues);
        commandSender.executeCommand(subName, "change", "confVal0", "1");
        commandSender.executeCommand(subName, "change", "confVal1", "2");
        commandSender.executeCommand(subName, "loadConfiguration", new Object[0]);
        configValues = (int[])commandSender.executeCommand(subName, "getConfValues", new Object[0]);
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArray8[2] = 2;
        Assert.assertArrayEquals((int[])nArray8, (int[])configValues);
        s.shutdown();
        Thread.sleep(2000L);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        commandSender.shutdown();
        Thread.sleep(5000L);
        System.setProperty("org.lsst.ccs.startInEngineeringMode", "false");
        System.setProperty("org.lsst.ccs.testcontext", "false");
        System.setProperty("org.lsst.ccs.sharedJVM", "false");
    }
}

