/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.configuration;

import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.CommandRejectedException;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.configuration.ConfigureMe;
import org.lsst.ccs.configuration.TestWriterProvider;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.testutils.CommandSender;

public class ConfigurationATest {
    private static double doubleVal = 7.65;
    private static double newVal = 10.0;
    private static CommandSender commandSender;
    private static LocalConfigurationProxy confProxy;
    private static TestWriterProvider writerProvider;
    private static NodeModularSubsystem s;
    private static final String subsystemName = "configurationA";
    private static ConfigureMe childModule;

    @BeforeClass
    public static void initAgents() throws Exception {
        System.setProperty("org.lsst.ccs.transport", "mock:single");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("org.lsst.ccs.testcontext", "true");
        commandSender = new CommandSender();
        try {
            s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"org/lsst/ccs/configuration/configurationA.groo");
            s.start();
            childModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("son"));
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown at subsystem startup : " + ex), (boolean)false);
            return;
        }
        Thread.sleep(5000L);
        commandSender.executeCommand(CommandRejectedException.class, subsystemName, "change", "value", doubleVal);
        commandSender.executeCommand(subsystemName, "newConfigurationContext", new Object[0]);
        commandSender.executeCommand("configurationA/son", "change", "value", doubleVal);
        Assert.assertEquals((String)"child value : ", (double)doubleVal, (double)childModule.getValue(), (double)0.0);
    }

    @AfterClass
    public static void shutdownAgents() throws Exception {
        try {
            s.shutdown();
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
        }
        commandSender.shutdown();
        Thread.sleep(5000L);
        System.setProperty("org.lsst.ccs.testcontext", "false");
        System.setProperty("org.lsst.ccs.sharedJVM", "false");
    }

    @Test
    public void testStaticParameterModification() {
        commandSender.executeCommand(IllegalStateException.class, subsystemName, "change", "info", "newValue");
        commandSender.executeCommand("configurationA/son", "change", "info", "newValue");
        Assert.assertEquals((String)"child value : ", (Object)"newValue", (Object)childModule.getInfo());
    }

    @Test
    public void testConstraintControllerCheck() {
        commandSender.executeCommand("configurationA/son", "change", "value", 10.0);
        Assert.assertEquals((String)"child value : ", (double)10.0, (double)childModule.getValue(), (double)0.0);
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/son", "change", "value", 1.0);
    }

    @Test
    public void testConstraintPredicateCheck() {
        commandSender.executeCommand("configurationA/predicateSon", "change", "value", newVal);
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/predicateSon", "change", "value", 1.0);
    }

    @Test
    public void testConstraintRangeCheck() {
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/son", "change", "max", 4000);
    }

    @Test
    public void testParameterNotConfigChanger() {
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/son", "change", "min", 1000);
    }

    @Test
    public void testUserDefinedConfigMethod() {
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/son", "setMinMax", -1, 0);
        commandSender.executeCommand(IllegalArgumentException.class, "configurationA/son", "setMinMax", 0, 5000);
        commandSender.executeCommand("configurationA/son", "setMinMax", 20, 1500);
        Assert.assertEquals((String)"min : ", (long)20L, (long)childModule.getMin());
        Assert.assertEquals((String)"max : ", (long)1500L, (long)childModule.getMax());
    }

    @Test
    public void testSaveConfigurationA() {
        confProxy = (LocalConfigurationProxy)s.getConfigurationProxy();
        writerProvider = new TestWriterProvider();
        confProxy.setWriterProvider((LocalConfigurationProxy.WriterProvider)writerProvider);
        commandSender.executeCommand("configurationA/son", "change", "value", doubleVal);
        commandSender.executeCommand("configurationA/son", "change", "info", "newValue");
        commandSender.executeCommand("configurationA/son", "change", "value", 10.0);
        commandSender.executeCommand("configurationA/predicateSon", "change", "value", newVal);
        commandSender.executeCommand("configurationA/son", "setMinMax", 20, 1500);
        commandSender.executeCommand(subsystemName, "saveConfiguration", subsystemName);
        String configName = String.valueOf(ConfigUtils.baseNameFromNames((String)s.getName(), (String)subsystemName, (String)s.getTag())) + ".properties";
        Properties properties = writerProvider.getConfigurationProperties(configName);
        String propValue = properties.getProperty("son//value");
        String maxValue = properties.getProperty("son//max");
        Assert.assertEquals((String)"son//value : ", (double)newVal, (double)Double.parseDouble(propValue), (double)0.0);
        Assert.assertEquals((String)"son//max : ", (long)1500L, (long)Integer.parseInt(maxValue));
        Assert.assertEquals((String)"modification size : ", (long)5L, (long)properties.size());
    }
}

