/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.configuration;

import java.util.HashMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.node_building.ModuleWithStructParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.testutils.CommandSender;

public class Configuration2parmsBTest {
    private static CommandSender commandSender;
    private static NodeModularSubsystem s;
    private static ModuleWithMapParms mainModule;
    private static ModuleWithStructParms structModule;
    private static ModuleWithMapParms mapChild;
    private static ModuleWithStructParms structModule2;
    private static final String subsystemName = "mapParmsA";

    static {
        s = null;
        mainModule = null;
        structModule = null;
        mapChild = null;
        structModule2 = null;
    }

    @BeforeClass
    public static void initAgents() {
        System.setProperty("org.lsst.ccs.transport", "mock:single");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("org.lsst.ccs.testcontext", "true");
        System.setProperty("org.lsst.ccs.startInEngineeringMode", "true");
        commandSender = new CommandSender();
        try {
            s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"/org/lsst/ccs/node_building/mapParmsA.groo");
            mainModule = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("main"));
            structModule = (ModuleWithStructParms)((Object)s.getLookup().getComponentByName("structChild"));
            mapChild = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("mapChild"));
            structModule2 = (ModuleWithStructParms)((Object)s.getLookup().getComponentByName("structChild2"));
            s.start();
            Thread.sleep(5000L);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Failed building subsystem : " + ex), (boolean)false);
            return;
        }
    }

    @AfterClass
    public static void shutdownAgents() throws Exception {
        try {
            s.shutdown();
            Thread.sleep(5000L);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown at shutdown : " + ex), (boolean)false);
        }
        commandSender.shutdown();
        System.setProperty("org.lsst.ccs.startInEngineeringMode", "false");
        System.setProperty("org.lsst.ccs.testcontext", "false");
        System.setProperty("org.lsst.ccs.sharedJVM", "false");
    }

    @Test
    public void testMapConfiguration() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("min", 20);
        map.put("max", 300);
        commandSender.executeCommand(subsystemName, "change", "minMax", map);
        System.out.println(" state of Main " + (Object)((Object)mainModule));
        Assert.assertEquals((String)"Main min value : ", (long)20L, (long)mainModule.getMin());
        Assert.assertEquals((String)"Main max value : ", (long)300L, (long)mainModule.getMax());
    }

    @Test
    public void testMapPredicateConfiguration() {
        HashMap<String, Integer> smallMap = new HashMap<String, Integer>();
        smallMap.put("min", 12);
        smallMap.put("max", 42);
        HashMap<String, Integer> failMap = new HashMap<String, Integer>();
        failMap.put("min", 9);
        failMap.put("max", 200);
        commandSender.executeCommand("mapParmsA/mapChild", "change", "minMax", smallMap);
        System.out.println(" state of MapChild " + (Object)((Object)mapChild));
        Assert.assertEquals((String)"mapChild min value : ", (long)12L, (long)mapChild.getMin());
        Assert.assertEquals((String)"mapChild max value : ", (long)42L, (long)mapChild.getMax());
        commandSender.executeCommand(IllegalArgumentException.class, "mapParmsA/mapChild", "change", "minMax", failMap);
    }

    @Test
    public void testStructConfiguration() {
        int[] ctorArgs = new int[]{40, 450};
        commandSender.executeCommand("mapParmsA/structChild", "change", "minMax", ctorArgs);
        System.out.println(" state of child " + (Object)((Object)structModule));
        Assert.assertEquals((String)" min value : ", (long)40L, (long)structModule.getMin());
        Assert.assertEquals((String)" max value : ", (long)450L, (long)structModule.getMax());
    }

    @Test
    public void testStructPredicateConfiguration() {
        int[] smallList = new int[]{13, 41};
        int[] failList = new int[]{9, 200};
        commandSender.executeCommand("mapParmsA/structChild2", "change", "minMax", smallList);
        System.out.println(" state of child " + (Object)((Object)structModule));
        Assert.assertEquals((String)" min value : ", (long)13L, (long)structModule2.getMin());
        Assert.assertEquals((String)" max value : ", (long)41L, (long)structModule2.getMax());
        commandSender.executeCommand(IllegalArgumentException.class, "mapParmsA/structChild2", "change", "minMax", failList);
    }
}

