package org.lsst.ccs.startup;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.*;
import org.lsst.ccs.config.*;
import org.lsst.gruth.jutils.DescriptiveNode;

/**
 * Starts a subsystem by requiring data from the network.
 * tow different options:
 * <UL>
 *     <LI>no argument provided to the call: the boot code broadcast the MAC address and waits for command</LI>
 *     <LI> arguments provided subsystem name, configuration name , tag: the boot code broadcasts a request and waits for a command
 *     if time out it searches of a local file in the cache</LI>
 * </UL>
 *
 * if property <TT>org.lsst.ccs.testcontext</TT> is set then the status message notifies server that only a test server
 * should be used.
 * @author bamade
 */
// Date: 25/06/12

public class SubsystemBootFromBus {
    static volatile boolean commandReceived ;
    static Exception thrown ;
    static final long TIMEOUT = 1000 ;

    public static void main(String[] args) throws Exception {
        String requestedSubsystem = "" ;
        String requestedConfiguration = "" ;
        String requestedTag = "" ;
        switch(args.length) {
            case 3: requestedTag = args[2] ;
            case 2: requestedConfiguration = args[1] ;
            case 1: requestedSubsystem = args[0] ;
        }
        //get MAC address
        String macAddress = Subsystem.getEthHardAddress() ;
        //TODO: get current deploymentDescriptor
        MessagingFactory mfact = MessagingFactory.getInstance().forSubsystem(macAddress) ;
        // register the boot with MacAddress to buses: status and command
        mfact.addCommandListener(new CommandListener() {
            @Override
            public void onCommand(Command m) {
                if(m instanceof BootCommand) {
                    String userName = "" ;
                    int level = PackCst.DESIGNER_LEVEL ;
                    commandReceived = true ;
                    BootCommand bcmd = (BootCommand) m ;
                    String subsystemName = bcmd.getSubsystemName() ;
                    String configName = bcmd.getConfigName() ;
                    String tag =  bcmd.getTag() ;
                    ConfigProfile configProfile = null ;
                    SubsystemDescription description = null ;
                    if(configName != null && ! "".equals(configName)) {
                         configProfile = (ConfigProfile)bcmd.getConfigurationData() ;
                        description = configProfile.getSubsystemDescription() ;
                    } else {
                        description = (SubsystemDescription)bcmd.getConfigurationData();
                        configProfile = Factories.createConfigProfile(description,configName,tag, userName, level) ;
                    }
                    DataFlavour dataFlavour = description.getDataFlavour() ;

                    DescriptiveNode componentNode = null ;
                    switch(dataFlavour) {
                        case TREE_FROM_SOURCE:
                            componentNode = ((TextAndNode) description.getDescriptionData()).getComponentNode() ;
                            break ;
                         case PURE_OBJECT_TREE:
                             componentNode = (DescriptiveNode) description.getDescriptionData() ;
                             break ;
                    }
                    if(componentNode != null) {
                        try {
                            //TODO: save before or after successful boot?
                            //TODO: change the proxy ...
                            //TODO: use busConfigurationAccess instead
                            LocalConfigurationProxy configurationAccess = new LocalConfigurationProxy(configProfile) ;
                            //TODO URGENT REWRITE null is not an option
                            Subsystem subsystem = BootUtils.rawSubsystemFromDescriptionNode(componentNode, null, subsystemName, configName, tag, configurationAccess) ;
                            // set up configuration access
                            //configurationAccess.setSubsystem(subsystem);
                            BootUtils.saveInCache(componentNode, subsystemName, configName, tag);
                            subsystem.start();
                        } catch (Exception exc) {
                            thrown = exc ;
                        }
                    }
                }
            }

            @Override
            public void onReply(CommandReply r) {  }

            @Override
            public void onAck(CommandAck a) {  }
        });
        // sends a specific status message
        BootStatus bootStatus = new BootStatus(requestedSubsystem,requestedConfiguration,requestedTag) ;
        bootStatus.setOrigin(macAddress);
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext","false");
        boolean inTestContext = "true".equals(testContext.toLowerCase());
        bootStatus.setInTestContext(inTestContext);
        mfact.sendStatus(bootStatus);
        // waits for command
        Thread.sleep(TIMEOUT);
        if(commandReceived) {
            if(thrown != null) throw thrown ;
        } else { // tries localy
            if("".equals(requestedSubsystem) && "".equals(requestedConfiguration)) {
                BootUtils.bootFromCache();
            } else {
            NamesAndTag namesAndTag = new NamesAndTag(requestedSubsystem,requestedConfiguration,requestedTag) ;
            SubsystemBootFromStream.main(new String[] {namesAndTag.toString()+".ser"});
            }

        }

    }
}
