package org.lsst.ccs.startup;

import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.utilities.structs.UniquePair;
import org.lsst.gruth.jutils.EffectiveNode;

import java.util.*;

/**
 * @author bamade
 */
// Date: 20/11/12

public class NodeLookup  implements ComponentLookupService{
    private EffectiveNode top ;
    /*
    * important: do not mix aliases and the dictionary of top ...
    * this will confuse codes.
     */
    private Map<String,Object> aliases = new HashMap<String,Object>() ;

    public NodeLookup(EffectiveNode top) {
        this.top = top;
    }

    @Override
    public Object getComponentByName(String name) {
        Object res = top.getIndirect(name);
        if(res == null) {
            return aliases.get(name) ;
        }
        return res ;
    }

    /**
     * aliases cannot override names in name componentNode structure
     * @param alias
     * @param object
     */
    @Override
    public void aliasObject(String alias, Object object){
        aliases.put(alias, object ) ;
    }

    @Override
    public <T> LinkedHashMap<String, T> getChildren(String parentName, Class<T> classFilter) {
        EffectiveNode current = (EffectiveNode) top.getNodeByName(parentName);
        ArrayList<EffectiveNode> children =  current.getChildren();
        if(children == null) {
            return new LinkedHashMap<>(0) ;
        }
        LinkedHashMap<String, T> mapRes = new LinkedHashMap<String, T>(children.size()) ;
        for(EffectiveNode child: children) {
            Object realValue = child.getRealValue();
            if(classFilter.isAssignableFrom(realValue.getClass())) {
                T realChild = (T) realValue ;
                String key = child.getKey() ;
                mapRes.put(key, realChild) ;
            }
        }
        return mapRes;
    }


    @Override
    public <T> List<T> listChildren(String parentName) {
        EffectiveNode current = (EffectiveNode) top.getNodeByName(parentName);
        ArrayList<EffectiveNode> children =  current.getChildren();
        if(children == null) {
            return Collections.EMPTY_LIST ;
        }
        ArrayList<T> result = new ArrayList<>(children.size()) ;
        for(EffectiveNode node : children) {
            result.add((T)node.getRealValue()) ;
        }
        return result ;
    }

    @Override
    public Map.Entry<String, Object> getParent(String componentName) {
        EffectiveNode current = (EffectiveNode) top.getNodeByName(componentName);
        //todo : use property isRootNode instead !
        EffectiveNode parent = (EffectiveNode) current.getParent();
        if (parent == null) {
            return new UniquePair<>("_EDEN_", null);
        }
        String key = parent.getKey() ;
        Object value = parent.getRealValue() ;
        return  new UniquePair<String, Object>(key, value) ;
    }
}
