package org.lsst.ccs.startup;

import java.util.Map;
import org.lsst.gruth.jutils.DescriptiveNode;

/**
 * A DescriptiveNode containing the name of the subsystem.
 * @author emarin
 */
public class MainDescriptiveNode extends DescriptiveNode {
    private final String subsystemName;

    public MainDescriptiveNode(DescriptiveNode parent, Object name, String subsystemName) {
        super(parent, name);
        this.subsystemName = subsystemName;
    }
    
    public MainDescriptiveNode(DescriptiveNode parent, Object name, Object value, String subsystemName) {
        super(parent, name, value);
        this.subsystemName = subsystemName;
    }

    public MainDescriptiveNode(DescriptiveNode parent, Object name, Map attributes, String subsystemName) {
        super(parent, name, attributes);
        this.subsystemName = subsystemName;
    }
    
    public MainDescriptiveNode(DescriptiveNode parent, Object name, Map attributes, Object value, String subsystemName) {
        super(parent, name, attributes, value);
        this.subsystemName = subsystemName;
    }
    
    public String getSubsystemName(){
        return subsystemName;
    }
    
}
