package org.lsst.ccs.startup;

import org.lsst.ccs.config.*;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.gruth.jutils.DescriptiveNode;

import java.io.PrintWriter;

/**
 * Utility to create locally the configuration properties file.
 * @author bamade
 */
// Date: 21/06/12

public class LocalDescriptionToConfigurationText {
    public static void main(String[] args) throws Exception {
        if(args.length < 1) {
            System.err.println("usage: java org.lsst.ccs.startup.LocalDescriptionToConfigurationText pathName\n"
                    + " where filename is  xx.ser or xx.groovy or xx.groo or xx\n"
                    + " pathName could be file (with '/' file separator) or resource path");
            System.exit(1);
        }
        String pathName = args[0] ;
        System.setProperty("org.lsst.ccs.namefromgroovy", String.valueOf(!pathName.contains(".")).toLowerCase());
        DescriptiveNode descriptiveNode = BootUtils.getDescriptiveNode(pathName);
        NamesAndTag namesAndTag = ConfigUtils.namesFromDescriptionPath(pathName) ;
        
        ASubsystemDescription subsystemDescription = (ASubsystemDescription)Factories.createSubsystemDescription(namesAndTag.getSubsystemName(), namesAndTag.getTag(), 
                "", "", descriptiveNode, DataFlavour.PURE_OBJECT_TREE, SubsystemDescription.DEFAULT_TREE_PARAMETER_FILTER);
        
        PrintWriter printWriter = new PrintWriter(ConfigUtils.baseNameFromNames(namesAndTag.getSubsystemName(),"XXXXX",namesAndTag.getTag())+".properties","ISO-8859-1");
        subsystemDescription.generateConfigProperties(printWriter, PackCst.DESIGNER_LEVEL);
        
        printWriter.flush();
        printWriter.close();
    }
}
