/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionInfoV2
implements Serializable {
    private final int defaultVersion;
    private final int latestVersion;
    private final List<Version> versions;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public VersionInfoV2(@JsonProperty(value="default") int defaultVersion, @JsonProperty(value="latest") int latestVersion, @JsonProperty(value="versions") List<Version> versions) {
        this.defaultVersion = defaultVersion;
        this.latestVersion = latestVersion;
        this.versions = versions;
    }

    public int getDefault() {
        return this.defaultVersion;
    }

    public int getLatest() {
        return this.latestVersion;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Serializable downgrade(Integer protocolVersion) {
        if (protocolVersion == null || protocolVersion < 2) {
            return new VersionInfo(this);
        }
        return this;
    }

    public String toString() {
        return "VersionInfo{defaultVersion=" + this.defaultVersion + ", latestVersion=" + this.latestVersion + ", versions=" + this.versions + "}";
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("latestVersion", this.getLatest());
        result.put("defaultVersion", this.getDefault());
        return result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Version
    extends RestFileInfo {
        private final int version;
        private final boolean hidden;
        private final String comment;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public Version(@JsonProperty(value="lastModified") long lastModified, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="lastAccessTime") long lastAccessTime, @JsonProperty(value="size") long size, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="name") String name, @JsonProperty(value="fileKey") String fileKey, @JsonProperty(value="directory") boolean directory, @JsonProperty(value="other") boolean other, @JsonProperty(value="regularFile") boolean regularFile, @JsonProperty(value="symbolicLink") boolean symbolicLink, @JsonProperty(value="versionedFile") boolean versionedFile, @JsonProperty(value="children") List<RestFileInfo> children, @JsonProperty(value="version") int version, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="comment") String comment) {
            super(lastModified, creationTime, lastAccessTime, size, mimeType, name, fileKey, directory, other, regularFile, symbolicLink, versionedFile, children);
            this.version = version;
            this.hidden = hidden;
            this.comment = comment == null ? "" : comment;
        }

        public Version(Path file, BasicFileAttributes fileAttributes, int version, boolean hidden, String comment) throws IOException {
            super(file, fileAttributes, false);
            this.version = version;
            this.hidden = hidden;
            this.comment = comment;
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

