/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.protocols.relay.RouteStatusListener;

public class DefaultRouteStatusListener
implements RouteStatusListener {
    protected final Supplier<Address> addr_getter;
    protected final List<String> up = new ArrayList<String>();
    protected final List<String> down = new ArrayList<String>();
    protected boolean verbose;

    public DefaultRouteStatusListener(Supplier<Address> s) {
        this.addr_getter = s;
    }

    public List<String> up() {
        return this.up;
    }

    public List<String> down() {
        return this.down;
    }

    public DefaultRouteStatusListener verbose(boolean b) {
        this.verbose = b;
        return this;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public Address addr() {
        return this.addr_getter != null ? this.addr_getter.get() : null;
    }

    @Override
    public synchronized void sitesUp(String ... sites) {
        if (this.verbose) {
            System.out.printf("%s: UP(%s)\n", this.addr(), String.join((CharSequence)",", sites));
        }
        this.up.addAll(Arrays.asList(sites));
    }

    @Override
    public synchronized void sitesDown(String ... sites) {
        if (this.verbose) {
            System.out.printf("%s: DOWN(%s)\n", this.addr(), String.join((CharSequence)",", sites));
        }
        this.down.addAll(Arrays.asList(sites));
    }

    @Override
    public void sitesUnreachable(String ... sites) {
        if (this.verbose) {
            System.out.printf("%s: SITE-UNREACHABLE(%s)\n", this.addr(), String.join((CharSequence)",", sites));
        }
    }

    @Override
    public void memberUnreachable(Address member) {
        if (this.verbose) {
            System.out.printf("%s: MEMBER-UNREACHABLE: %s\n", this.addr(), member);
        }
    }

    protected synchronized DefaultRouteStatusListener clear() {
        this.up.clear();
        this.down.clear();
        return this;
    }

    public String toString() {
        return String.format("down: %s, up: %s", this.down, this.up);
    }
}

