/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.commons.annotations.scanner;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.scanner.ReflectObject;

public class FieldAnnotationScanner<T extends Annotation> {
    private final Class<T> annotationCls;

    public FieldAnnotationScanner(Class<T> annotation) {
        this.annotationCls = annotation;
    }

    public ReflectObject<T> scan(Object target) {
        ReflectObjectImpl soi = new ReflectObjectImpl(target);
        for (Class<?> cls = target.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(this.annotationCls)) continue;
                soi.fields.put(field.getName(), field);
                soi.annotations.put(field.getName(), field.getAnnotation(this.annotationCls));
            }
        }
        if (soi.getFields().isEmpty()) {
            return null;
        }
        return soi.getFields().isEmpty() ? null : soi;
    }

    private class ReflectObjectImpl<T extends Annotation>
    implements ReflectObject<T> {
        private final Object target;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Map<String, T> annotations = new HashMap<String, T>();

        private ReflectObjectImpl(Object target) {
            this.target = target;
        }

        @Override
        public Map<String, Field> getFields() {
            return Collections.unmodifiableMap(this.fields);
        }

        @Override
        public T getAnnotation(String fieldName) {
            return (T)((Annotation)this.annotations.get(fieldName));
        }

        @Override
        public Object getTarget() {
            return this.target;
        }
    }
}

