/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.alert.AlertService;

public class InfluxDbClientService
implements AgentService,
ServiceLifecycle {
    private static final Logger LOG = Logger.getLogger("org.lsst.ccs.services.influxDb");
    @ConfigurationParameter(isFinal=true, category="InfluxDb", description="URL of the influxdb entry point", units="unitless")
    private volatile String influxDbUrl;
    @ConfigurationParameter(isFinal=true, category="InfluxDb", description="Name of the Influxdb database", units="unitless")
    private volatile String influxDbName;
    @ConfigurationParameter(isFinal=true, category="InfluxDb", description="Influxdb username", units="unitless")
    private volatile String influxDbUsername;
    @ConfigurationParameter(isFinal=true, category="InfluxDb", description="Influxdb password", units="unitless")
    private volatile String influxDbPassword;
    @ConfigurationParameter(isFinal=true, category="InfluxDb", maxLength=10, description="Map of Global Tags", units="unitless")
    private volatile Map<String, String> globalTags = new ConcurrentHashMap<String, String>();
    @ConfigurationParameter(category="InfluxDb", description="True/False to enable/disable this service.", units="unitless")
    private volatile boolean enabled = false;
    private volatile boolean hasStarted = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AlertService alertService;
    private final Alert influxDbAlert = new Alert("InfluxDbAlert", "Alert raised when there is a connection problem to InfluxDb");
    private volatile InfluxDB influxDb = new DummyInfluxDb();

    @Override
    public String getAgentServiceName() {
        return "influxDbClientService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        if (agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            SingleCategoryTag.setDefaultForCategory((String)"InfluxDb", (String)"system");
            return true;
        }
        return false;
    }

    @ConfigurationParameterChanger
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enabled = enabled;
            if (this.hasStarted) {
                this.initializeInfluxDbConnection();
            }
        } else {
            this.closeInfluxDbConnection();
            this.enabled = enabled;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void preStart() {
        this.initializeInfluxDbConnection();
        this.hasStarted = true;
    }

    @Override
    public void preInit() {
        this.alertService.registerAlert(this.influxDbAlert, new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                if (!InfluxDbClientService.this.enabled) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        });
    }

    private boolean initializeInfluxDbConnection() {
        if (!this.enabled) {
            return true;
        }
        try {
            if (this.influxDbUrl == null || this.influxDbUrl.isEmpty()) {
                throw new RuntimeException("When the InfluxDb service is activated, the URL and credetnials must be specified.");
            }
            this.influxDb = InfluxDBFactory.connect((String)this.influxDbUrl, (String)this.influxDbUsername, (String)this.influxDbPassword);
            this.influxDb = this.influxDb.setDatabase(this.influxDbName);
            Pong p = this.influxDb.ping();
            if (p == null || !p.isGood()) {
                throw new RuntimeException("Could not connect with InfluxDb " + p);
            }
            this.influxDb = this.influxDb.enableBatch(BatchOptions.DEFAULTS.actions(2000).flushDuration(500).exceptionHandler((failedPoints, throwable) -> LOG.severe(throwable.toString())));
            LOG.log(Level.FINE, "Initialized InfluxDb with URL {0}", this.influxDbUrl);
            RaisedAlertHistory history = this.alertService.getRaisedAlertSummary().getRaisedAlert(this.influxDbAlert.getAlertId());
            if (history != null && history.getLatestAlertState() != AlertState.NOMINAL) {
                this.alertService.raiseAlert(this.influxDbAlert, AlertState.NOMINAL, "Successfully initialized InfluxDb " + this.influxDbUrl);
            }
            return true;
        }
        catch (Exception e) {
            this.alertService.raiseAlert(this.influxDbAlert, AlertState.WARNING, e.getMessage());
            LOG.log(Level.SEVERE, "Problem initializing the connection to InfluxDb", e);
            return false;
        }
    }

    private void closeInfluxDbConnection() {
        if (this.enabled) {
            LOG.log(Level.FINE, "Closed connection to InfluxDb {0}", this.influxDbUrl);
            this.influxDb.close();
            this.influxDb = new DummyInfluxDb();
        }
    }

    @Override
    public void preShutdown() {
        this.closeInfluxDbConnection();
    }

    public void write(Point point) {
        LOG.log(Level.FINE, "Writing to point influxDb {0}", point);
        this.influxDb.write(point);
    }

    public void write(BatchPoints points) {
        LOG.log(Level.FINE, "Writing to batch of points influxDb {0}", points);
        this.influxDb.write(points);
    }

    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    public BatchPoints createBatchPoints() {
        return BatchPoints.database((String)this.influxDbName).build();
    }

    private static class DummyInfluxDb
    implements InfluxDB {
        private DummyInfluxDb() {
        }

        public InfluxDB setLogLevel(InfluxDB.LogLevel ll) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableGzip() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB disableGzip() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isGzipEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch(BatchOptions bo) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch(int i, int i1, TimeUnit tu) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch(int i, int i1, TimeUnit tu, ThreadFactory tf) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch(int i, int i1, TimeUnit tu, ThreadFactory tf, BiConsumer<Iterable<Point>, Throwable> bc, InfluxDB.ConsistencyLevel cl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB enableBatch(int i, int i1, TimeUnit tu, ThreadFactory tf, BiConsumer<Iterable<Point>, Throwable> bc) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void disableBatch() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isBatchEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Pong ping() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String version() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void write(Point point) {
        }

        public void write(String string) {
        }

        public void write(List<String> list) {
        }

        public void write(String string, String string1, Point point) {
        }

        public void write(int i, Point point) {
        }

        public void write(BatchPoints bp) {
        }

        public void writeWithRetry(BatchPoints bp) {
        }

        public void write(String string, String string1, InfluxDB.ConsistencyLevel cl, String string2) {
        }

        public void write(String string, String string1, InfluxDB.ConsistencyLevel cl, TimeUnit tu, String string2) {
        }

        public void write(String string, String string1, InfluxDB.ConsistencyLevel cl, List<String> list) {
        }

        public void write(String string, String string1, InfluxDB.ConsistencyLevel cl, TimeUnit tu, List<String> list) {
        }

        public void write(int i, String string) {
        }

        public void write(int i, List<String> list) {
        }

        public QueryResult query(Query query) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, Consumer<QueryResult> cnsmr, Consumer<Throwable> cnsmr1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, int i, Consumer<QueryResult> cnsmr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, int i, BiConsumer<InfluxDB.Cancellable, QueryResult> bc) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, int i, Consumer<QueryResult> cnsmr, Runnable r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, int i, BiConsumer<InfluxDB.Cancellable, QueryResult> bc, Runnable r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void query(Query query, int i, BiConsumer<InfluxDB.Cancellable, QueryResult> bc, Runnable r, Consumer<Throwable> cnsmr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public QueryResult query(Query query, TimeUnit tu) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void createDatabase(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void deleteDatabase(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List<String> describeDatabases() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean databaseExists(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void flush() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void close() {
        }

        public InfluxDB setConsistency(InfluxDB.ConsistencyLevel cl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB setDatabase(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InfluxDB setRetentionPolicy(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void createRetentionPolicy(String string, String string1, String string2, String string3, int i, boolean bln) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void createRetentionPolicy(String string, String string1, String string2, int i, boolean bln) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void createRetentionPolicy(String string, String string1, String string2, String string3, int i) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void dropRetentionPolicy(String string, String string1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

