/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.misc;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;

public class ExtendableURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static ExtendableURLStreamHandlerFactory factory;
    private static final HashMap<String, URLStreamHandlerFactory> byProtocol;
    private static final ArrayList<URLStreamHandlerFactory> others;

    public static synchronized void add(URLStreamHandlerFactory handlerFactory, String ... protocols) {
        if (protocols.length == 0) {
            others.add(handlerFactory);
        } else {
            for (String protocol : protocols) {
                if (byProtocol.containsKey(protocol)) {
                    throw new IllegalStateException("Factory already set for protocol " + protocol + ".");
                }
                byProtocol.put(protocol, handlerFactory);
            }
        }
        if (factory == null) {
            factory = new ExtendableURLStreamHandlerFactory();
            try {
                URL.setURLStreamHandlerFactory(factory);
            }
            catch (Error x) {
                factory = null;
                throw new IllegalStateException("URLStreamHandlerFactory has already been set for this JVM.", x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        ArrayList<URLStreamHandlerFactory> ff = null;
        Class<ExtendableURLStreamHandlerFactory> clazz = ExtendableURLStreamHandlerFactory.class;
        synchronized (ExtendableURLStreamHandlerFactory.class) {
            URLStreamHandlerFactory f = byProtocol.get(protocol);
            if (f == null) {
                ff = new ArrayList<URLStreamHandlerFactory>(others);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (f == null) {
                for (URLStreamHandlerFactory fac : ff) {
                    URLStreamHandler out = fac.createURLStreamHandler(protocol);
                    if (out == null) continue;
                    return out;
                }
                return null;
            }
            return f.createURLStreamHandler(protocol);
        }
    }

    static {
        byProtocol = new HashMap(0);
        others = new ArrayList(0);
    }
}

