/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import org.lsst.ccs.utilities.logging.LogPropertiesLoader;

public class StackTraceFormats {
    private static int depth = -1;
    private static volatile boolean modified = false;

    public static int getDepth() {
        return depth;
    }

    public static void setDepth(int depth) {
        StackTraceFormats.depth = depth;
        modified = true;
    }

    public static void setDepthFromInitialProperties() {
        if (modified) {
            return;
        }
        int depth = LogPropertiesLoader.loaderGetIntProperty("org.lsst.ccs.logging.StackTraceFormats.depth", -1);
        StackTraceFormats.setDepth(depth);
    }

    public static String toString(Throwable throwable) {
        return StackTraceFormats.toString(throwable, 1);
    }

    public static String toString(Throwable throwable, int level) {
        StackTraceElement[] traces;
        StringBuilder stb = new StringBuilder(String.valueOf(throwable)).append('\n');
        for (StackTraceElement trace : traces = throwable.getStackTrace()) {
            StackTraceFormats.indent(stb, level).append(trace).append('\n');
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            StackTraceFormats.indent(stb, level - 1).append("caused by : ").append(StackTraceFormats.toString(cause, level + 1));
        }
        return stb.toString();
    }

    private static StringBuilder indent(StringBuilder stb, int level) {
        for (int ix = 0; ix <= level; ++ix) {
            stb.append("  ");
        }
        return stb;
    }
}

