/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation.unixlike;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.lsst.ccs.rest.file.server.client.implementation.unixlike.AbstractPathBuilder;

public abstract class AbstractPath
implements Path {
    protected static final String DELIMETER = "/";
    private static final LinkedList<String> EMPTY_PATH = new LinkedList();
    private final boolean isAbsolute;
    private final LinkedList<String> path;
    private final AbstractPathBuilder builder;

    protected AbstractPath(AbstractPathBuilder builder, String path) {
        this.builder = builder;
        this.isAbsolute = path.startsWith(DELIMETER);
        if (this.isAbsolute) {
            path = path.substring(1);
        }
        this.path = path.isEmpty() ? EMPTY_PATH : new LinkedList<String>(Arrays.asList(path.split("/+")));
    }

    protected AbstractPath(AbstractPathBuilder builder, boolean isAbsolute, List<String> path) {
        this.builder = builder;
        this.isAbsolute = isAbsolute;
        this.path = path instanceof LinkedList ? (LinkedList<Object>)path : new LinkedList<String>(path);
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public Path getRoot() {
        return this.builder.getPath(true, EMPTY_PATH);
    }

    @Override
    public Path getFileName() {
        return this.path.isEmpty() ? null : this.builder.getPath(this.path.getLast(), new String[0]);
    }

    @Override
    public Path getParent() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.builder.getPath(this.isAbsolute, this.path.subList(0, this.path.size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.path.size();
    }

    @Override
    public Path getName(int index) {
        return this.builder.getPath(false, this.path.subList(index, index + 1));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.builder.getPath(false, this.path.subList(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        return this.toString().startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.toString().endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String other) {
        return this.toString().endsWith(other);
    }

    @Override
    public Path normalize() {
        LinkedList<String> newPath = new LinkedList<String>(this.path);
        ListIterator i = newPath.listIterator();
        while (i.hasNext()) {
            String previous = i.hasPrevious() ? (String)newPath.get(i.previousIndex()) : null;
            String element = (String)i.next();
            if (".".equals(element) || element.isEmpty()) {
                i.remove();
                continue;
            }
            if (!"..".equals(element) || previous == null || "..".equals(previous)) continue;
            i.remove();
            i.previous();
            i.remove();
        }
        return this.builder.getPath(this.isAbsolute, newPath);
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        LinkedList<String> newPath = new LinkedList<String>(this.path);
        for (int i = 0; i < other.getNameCount(); ++i) {
            newPath.add(other.getName(i).toString());
        }
        return this.builder.getPath(this.isAbsolute, newPath);
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(this.builder.getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.builder.getPath(other, new String[0]));
    }

    @Override
    public Path relativize(Path other) {
        if (!Objects.equals(other.getFileSystem(), this.getFileSystem())) {
            throw new IllegalArgumentException("Incompatible file system");
        }
        AbstractPath otherAbsolute = (AbstractPath)other.toAbsolutePath();
        AbstractPath thisAbsolute = (AbstractPath)this.toAbsolutePath();
        int commonRootDepth = 0;
        for (int i = 0; i < Math.min(thisAbsolute.path.size(), otherAbsolute.path.size()) && thisAbsolute.path.get(i).equals(otherAbsolute.path.get(i)); ++i) {
            ++commonRootDepth;
        }
        LinkedList<String> relativePath = new LinkedList<String>();
        for (int i = commonRootDepth; i < thisAbsolute.path.size(); ++i) {
            relativePath.add("..");
        }
        relativePath.addAll(otherAbsolute.path.subList(commonRootDepth, otherAbsolute.path.size()));
        return this.builder.getPath(false, relativePath);
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute) {
            return this;
        }
        return this.getRoot().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Watch service not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Watch service not supported yet.");
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AbstractPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < AbstractPath.this.getNameCount()) {
                    Path result = AbstractPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Conversion to File not supported.");
    }

    @Override
    public String toString() {
        return (this.isAbsolute ? DELIMETER : "") + String.join((CharSequence)DELIMETER, this.path);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.getFileSystem());
        hash = 89 * hash + Objects.hashCode(this.path);
        hash = 89 * hash + (this.isAbsolute ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPath other = (AbstractPath)obj;
        if (this.isAbsolute != other.isAbsolute) {
            return false;
        }
        if (!Objects.equals(this.getFileSystem(), other.getFileSystem())) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }
}

