/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.Serializable;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

class BusCommandSet
implements CommandSet {
    private final String dictionaryPath;
    private final Dictionary dict;
    private final ConcurrentMessagingUtils sci;

    BusCommandSet(ConcurrentMessagingUtils sci, String dictionaryPath, Dictionary dict) {
        this.sci = sci;
        this.dictionaryPath = dictionaryPath;
        this.dict = dict;
    }

    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    public Object invoke(BasicCommand bc) throws CommandInvocationException, CommandArgumentMatchException {
        DictionaryCommand findCommand = this.dict.findCommand(bc);
        if (findCommand == null) {
            throw new CommandInvocationException("No handler found for command %s with %d arguments", new Object[]{bc.getCommand(), bc.getArgumentCount()});
        }
        if (findCommand.hasOptions()) {
            for (String opt : bc.getOptions().getOptions()) {
                boolean isOptionSupported = false;
                boolean isShortOption = opt.length() == 1;
                for (SupportedOption so : findCommand.getSupportedOptions()) {
                    isOptionSupported = isShortOption ? so.getSingleLetterName().equals(opt) : so.getName().equals(opt);
                    if (!isOptionSupported) continue;
                    break;
                }
                if (isOptionSupported) continue;
                throw new CommandInvocationException("Option " + opt + " is not one of the supported options: " + findCommand.getSupportedOptions(), new Object[0]);
            }
        } else if (bc.getOptions().hasOptions()) {
            throw new CommandInvocationException("Options cannot be provided to a command that does not support them.", new Object[0]);
        }
        CommandRequest basicCommandBusMessage = new CommandRequest(this.dictionaryPath, bc);
        try {
            Serializable nackObj;
            Object result = this.sci.sendSynchronousCommand(basicCommandBusMessage);
            if (result instanceof CommandNack && (nackObj = ((CommandNack)result).getObject()) instanceof Throwable) {
                throw new CommandInvocationException("The command resulted in a Nack : " + ((CommandNack)result).getReason(), (Throwable)nackObj);
            }
            return result;
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

