/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ConfigurationData
implements Serializable {
    private static final long serialVersionUID = 5968743302322344L;
    private ConfigurationState configurationState;
    private Map<String, String> configurationData = new HashMap<String, String>();
    private Map<String, String> configuredData = new HashMap<String, String>();
    private Map<String, String> categoryDescription = new HashMap<String, String>();
    private String configurationDescription;
    private String fullConfigurationDescription;
    private Map<String, Long> categoryChecksum = new HashMap<String, Long>();
    private String configOperation;
    private CCSTimeStamp ccsTimestamp;
    private final List<String> recentChanges = new ArrayList<String>();
    private long dataChecksum = 0L;

    public String getConfigurationDescription() {
        return this.configurationDescription;
    }

    public String getFullConfigurationDescription() {
        return this.fullConfigurationDescription;
    }

    public String getCategoryDescription(String category) {
        return this.categoryDescription.get(category);
    }

    public String getConfigurationParameterValue(String parameterPath) {
        return this.configurationData.get(parameterPath);
    }

    public ConfigurationState getConfigurationState() {
        return this.configurationState;
    }

    public long getCategoryChecksum(String category) {
        return this.categoryChecksum.get(category);
    }

    public String getConfigurationOperation() {
        return this.configOperation;
    }

    public Map<String, String> getCurrentValues() {
        return this.configurationData;
    }

    public Map<String, String> getConfiguredValues() {
        return this.configuredData;
    }

    public Set<String> getCategories() {
        return this.categoryDescription.keySet();
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimestamp;
    }

    public List<String> getLatestChanges() {
        return this.recentChanges;
    }

    public long getDataChecksum() {
        return this.dataChecksum;
    }

    public static ConfigurationData buildConfigurationData(ConfigurationInfo ci, List<ConfigurationParameterInfo> pars, String co) {
        ConfigurationData configData = new ConfigurationData();
        configData.configurationState = ci.getConfigurationState();
        configData.configurationDescription = ci.getConfigurationDescription();
        configData.fullConfigurationDescription = ci.getFullConfigurationDescription();
        configData.configOperation = co;
        configData.dataChecksum += (long)configData.configurationDescription.hashCode();
        for (String category : ci.getCategorySet()) {
            configData.categoryDescription.put(category, ci.getConfigurationDescriptionObject().getCategoryTag(category).toString());
            Long categoryChecksum = ci.getCategoryDataChecksum(category);
            configData.categoryChecksum.put(category, ci.getCategoryDataChecksum(category));
            configData.dataChecksum += categoryChecksum.longValue();
        }
        for (ConfigurationParameterInfo par : pars) {
            String parPath = par.getPathName();
            String currentValue = par.getCurrentValue();
            configData.configurationData.put(parPath, currentValue);
            String configuredValue = par.getConfiguredValue();
            if (currentValue.equals(configuredValue)) continue;
            configData.configuredData.put(parPath, configuredValue);
        }
        configData.ccsTimestamp = ci.getCCSTimeStamp();
        configData.recentChanges.clear();
        for (ConfigurationParameterInfo cpi : ci.getLatestChanges()) {
            configData.recentChanges.add(cpi.getPathName());
        }
        return configData;
    }
}

