/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.Alert;

@SkipEncoding
public class MutedAlertRequest
implements Serializable {
    private static final long serialVersionUID = 54423487100235214L;
    public static final String PUBLICATION_KEY = "MutedAlertRequestPublicationKey";
    private static final AtomicLong idCreator = new AtomicLong(0L);
    private final long uniqueId = idCreator.getAndAdd(1L);
    private final String subsystemName;
    private final String userName;
    private final long creationMillis = System.currentTimeMillis();
    private final int durationInSeconds;
    private final Pattern alertIdPattern;
    private final String alertIdRegEx;

    public MutedAlertRequest(String subsystemName, String alertIdRegEx, int durationInSeconds, String userName) {
        this.subsystemName = subsystemName;
        this.alertIdPattern = Pattern.compile(alertIdRegEx);
        this.durationInSeconds = durationInSeconds;
        this.userName = userName;
        this.alertIdRegEx = alertIdRegEx;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public long getExpirationMillis() {
        return this.creationMillis + (long)this.durationInSeconds * 1000L;
    }

    public int getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public String getAlertIdRegEx() {
        return this.alertIdRegEx;
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.getExpirationMillis();
    }

    public boolean isSubsystemAlertMuted(String subsystem, Alert alert) {
        return this.isMuted(subsystem, alert.getAlertId());
    }

    public boolean isAlertIdMuted(String alertId) {
        int slash;
        if (alertId.startsWith("/")) {
            alertId = alertId.substring(1);
        }
        if ((slash = alertId.indexOf("/")) < 1) {
            throw new IllegalArgumentException("The provided alertId is not fully qualified. It must start with a subsystem name. " + alertId);
        }
        String subsystem = alertId.substring(0, slash);
        alertId = alertId.replace(subsystem + "/", "");
        return this.isMuted(subsystem, alertId);
    }

    public boolean matches(String alertId) {
        return this.alertIdPattern.matcher(alertId).matches();
    }

    private boolean isMuted(String subsystem, String alertId) {
        return this.isValid() && subsystem.equals(this.subsystemName) && this.alertIdPattern.matcher(alertId).matches();
    }

    public String toString() {
        int secondsLeft = (int)((this.getExpirationMillis() - System.currentTimeMillis()) / 1000L);
        return "Id: " + this.getUniqueId() + " subsystem: " + this.subsystemName + " regEx: " + this.alertIdRegEx + " muted by: " + this.userName + " validity left: " + secondsLeft + " (s)";
    }
}

