/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;

public class TransferQueueBundler
extends BaseBundler
implements Runnable {
    protected BlockingQueue<Message> queue;
    protected List<Message> remove_queue;
    protected volatile Thread bundler_thread;
    @Property(description="When the queue is full, senders will drop a message rather than wait until space is available (https://issues.redhat.com/browse/JGRP-2765)")
    protected boolean drop_when_full;
    protected volatile boolean running = true;
    @ManagedAttribute(description="Number of times a message was sent because the queue was full")
    protected long num_sends_because_full_queue;
    @ManagedAttribute(description="Number of times a message was sent because there was no message available in the queue")
    protected long num_sends_because_no_msgs;
    @ManagedAttribute(description="Number of dropped messages (when drop_when_full is true)")
    protected long num_drops_on_full_queue;
    @ManagedAttribute(description="Average fill size of the queue (in bytes)")
    protected final AverageMinMax avg_fill_count = new AverageMinMax();
    protected static final String THREAD_NAME = "TQ-Bundler";

    public TransferQueueBundler() {
        this.remove_queue = new ArrayList<Message>(16);
    }

    protected TransferQueueBundler(BlockingQueue<Message> queue) {
        this.queue = queue;
        this.remove_queue = new ArrayList<Message>(16);
    }

    public TransferQueueBundler(int capacity) {
        this(new ArrayBlockingQueue<Message>(TransferQueueBundler.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    public Thread getThread() {
        return this.bundler_thread;
    }

    public int getBufferSize() {
        return this.queue.size();
    }

    public int removeQueueSize() {
        return this.remove_queue.size();
    }

    public TransferQueueBundler removeQueueSize(int size) {
        this.remove_queue = new ArrayList<Message>(size);
        return this;
    }

    public boolean getDropWhenFull() {
        return this.drop_when_full;
    }

    public TransferQueueBundler setDropWhenFull(boolean b) {
        this.drop_when_full = b;
        return this;
    }

    @Override
    public Map<String, Object> getStats() {
        Map<String, Object> retval = super.getStats();
        if (retval == null) {
            retval = new HashMap<String, Object>(3);
        }
        retval.put("sends_because_full", this.num_sends_because_full_queue);
        retval.put("sends_because_no_msgs", this.num_sends_because_no_msgs);
        retval.put("avg_fill_count", this.avg_fill_count);
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_drops_on_full_queue = 0L;
        this.num_sends_because_no_msgs = 0L;
        this.num_sends_because_full_queue = 0L;
        this.avg_fill_count.clear();
    }

    @Override
    public void init(TP tp) {
        super.init(tp);
        if (this.queue == null) {
            this.queue = new ArrayBlockingQueue<Message>(TransferQueueBundler.assertPositive(tp.getBundlerCapacity(), "bundler capacity cannot be " + tp.getBundlerCapacity()));
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.bundler_thread = this.transport.getThreadFactory().newThread(this, THREAD_NAME);
        this.running = true;
        this.bundler_thread.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.bundler_thread;
        this.bundler_thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.drain();
    }

    @Override
    public int size() {
        return super.size() + this.removeQueueSize() + this.getBufferSize();
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (!this.running) {
            return;
        }
        if (this.drop_when_full) {
            if (!this.queue.offer(msg)) {
                ++this.num_drops_on_full_queue;
            }
        } else {
            this.queue.put(msg);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = this.queue.take();
                if (msg == null) continue;
                this.addAndSendIfSizeExceeded(msg);
                block3: while (true) {
                    this.remove_queue.clear();
                    int num_msgs = this.queue.drainTo(this.remove_queue);
                    if (num_msgs <= 0) break;
                    int i = 0;
                    while (true) {
                        if (i >= this.remove_queue.size()) continue block3;
                        msg = this.remove_queue.get(i);
                        this.addAndSendIfSizeExceeded(msg);
                        ++i;
                    }
                    break;
                }
                if (this.count <= 0L) continue;
                ++this.num_sends_because_no_msgs;
                this.avg_fill_count.add(this.count);
                this._sendBundledMessages();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void addAndSendIfSizeExceeded(Message msg) {
        long size = msg.size();
        if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
            ++this.num_sends_because_full_queue;
            this.avg_fill_count.add(this.count);
            this._sendBundledMessages();
        }
        this._addMessage(msg, size);
    }

    protected void drain() {
        Message msg;
        while ((msg = (Message)this.queue.poll()) != null) {
            this.addAndSendIfSizeExceeded(msg);
        }
        this._sendBundledMessages();
    }

    protected void _sendBundledMessages() {
        this.lock.lock();
        try {
            this.sendBundledMessages();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addMessage(Message msg, long size) {
        this.lock.lock();
        try {
            this.addMessage(msg, size);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

