/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.TP;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SubmitToThreadPool;

public class MaxOneThreadPerSender
extends SubmitToThreadPool {
    protected final MessageTable mcasts = new MessageTable();
    protected final MessageTable ucasts = new MessageTable();
    protected int max_buffer_size;
    protected boolean resize = true;

    @ManagedOperation(description="Dumps unicast and multicast tables")
    public String dump() {
        return String.format("\nmcasts:\n%s\nucasts:\n%s", this.mcasts, this.ucasts);
    }

    @Override
    public void reset() {
        this.mcasts.map.values().forEach(Entry::reset);
        this.ucasts.map.values().forEach(Entry::reset);
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        this.max_buffer_size = this.tp.getMessageProcessingMaxBufferSize();
        this.resize = this.max_buffer_size == 0;
    }

    @Override
    public void destroy() {
        this.mcasts.clear();
        this.ucasts.clear();
    }

    @Override
    public void loopback(Message msg, boolean oob, boolean internal) {
        if (oob || internal) {
            super.loopback(msg, oob, internal);
            return;
        }
        MessageTable table = msg.dest() == null ? this.mcasts : this.ucasts;
        table.process(msg, true);
    }

    @Override
    public void process(Message msg, boolean oob, boolean internal) {
        if (oob || internal) {
            super.process(msg, oob, internal);
            return;
        }
        MessageTable table = msg.dest() == null ? this.mcasts : this.ucasts;
        table.process(msg, false);
    }

    @Override
    public void process(MessageBatch batch, boolean oob, boolean internal) {
        if (oob || internal) {
            super.process(batch, oob, internal);
            return;
        }
        MessageTable table = batch.dest() == null ? this.mcasts : this.ucasts;
        table.process(batch);
    }

    public void viewChange(List<Address> members) {
        this.mcasts.viewChange(members);
        this.ucasts.viewChange(members);
    }

    protected class MessageTable {
        protected final ConcurrentMap<Address, Entry> map = new ConcurrentHashMap<Address, Entry>();

        protected Entry get(Address dest, Address sender) {
            IntFunction<MessageBatch> creator_func;
            Entry tmp;
            Entry entry = (Entry)this.map.get(sender);
            if (entry == null && (tmp = this.map.putIfAbsent(sender, entry = new Entry(creator_func = cap -> new MessageBatch(cap).dest(dest).clusterName(MaxOneThreadPerSender.this.tp.getClusterNameAscii()).sender(sender).multicast(dest == null)))) != null) {
                entry = tmp;
            }
            return entry;
        }

        protected void clear() {
            this.map.clear();
        }

        protected void process(Message msg, boolean loopback) {
            Address dest = msg.dest();
            Address sender = msg.src();
            this.get(dest, sender).process(msg, loopback);
        }

        protected void process(MessageBatch batch) {
            Address dest = batch.dest();
            Address sender = batch.sender();
            this.get(dest, sender).process(batch);
        }

        protected void viewChange(List<Address> mbrs) {
            this.map.keySet().retainAll(mbrs);
        }

        public String toString() {
            return this.map.entrySet().stream().collect(StringBuilder::new, (sb, e) -> sb.append(e).append("\n"), (a, b) -> {}).toString();
        }
    }

    protected class BatchHandlerLoop
    extends SubmitToThreadPool.BatchHandler {
        protected final Entry entry;
        protected final boolean loopback;

        public BatchHandlerLoop(MessageBatch batch, Entry entry, boolean loopback) {
            super(MaxOneThreadPerSender.this, batch);
            this.entry = entry;
            this.loopback = loopback;
        }

        @Override
        public void run() {
            do {
                try {
                    super.run();
                }
                catch (Throwable t) {
                    MaxOneThreadPerSender.this.log.error("failed processing batch", t);
                }
            } while (this.entry.workAvailable(this.batch));
        }

        @Override
        protected void passBatchUp() {
            MaxOneThreadPerSender.this.tp.passBatchUp(this.batch, !this.loopback, !this.loopback);
        }
    }

    protected class Entry {
        protected final Lock lock = new ReentrantLock();
        protected boolean running;
        protected MessageBatch batch;
        protected IntFunction<MessageBatch> batch_creator;
        protected final LongAdder submitted_msgs = new LongAdder();
        protected final LongAdder submitted_batches = new LongAdder();
        protected final LongAdder queued_msgs = new LongAdder();
        protected final LongAdder queued_batches = new LongAdder();

        protected Entry(IntFunction<MessageBatch> creator) {
            this.batch_creator = creator;
            this.batch = this.batch_creator.apply(MaxOneThreadPerSender.this.max_buffer_size > 0 ? MaxOneThreadPerSender.this.max_buffer_size : 16);
        }

        public Entry reset() {
            Stream.of(this.submitted_msgs, this.submitted_batches, this.queued_msgs, this.queued_batches).forEach(LongAdder::reset);
            return this;
        }

        protected void process(Message msg, boolean loopback) {
            if (!this.allowedToSubmitToThreadPool(msg)) {
                return;
            }
            this.submit(msg, loopback);
        }

        protected void process(MessageBatch batch) {
            if (!this.allowedToSubmitToThreadPool(batch)) {
                return;
            }
            this.submit(batch);
        }

        protected void submit(Message msg, boolean loopback) {
            try {
                this.submitted_msgs.increment();
                BatchHandlerLoop handler = new BatchHandlerLoop(this.batch_creator.apply(16).add(msg), this, loopback);
                if (!MaxOneThreadPerSender.this.tp.submitToThreadPool(handler, false)) {
                    this.setRunning(false);
                }
            }
            catch (Throwable t) {
                this.setRunning(false);
            }
        }

        protected void submit(MessageBatch mb) {
            try {
                this.submitted_batches.increment();
                BatchHandlerLoop handler = new BatchHandlerLoop(this.batch_creator.apply(mb.size()).add(mb), this, false);
                if (!MaxOneThreadPerSender.this.tp.submitToThreadPool(handler, false)) {
                    this.setRunning(false);
                }
            }
            catch (Throwable t) {
                this.setRunning(false);
            }
        }

        protected boolean allowedToSubmitToThreadPool(Message msg) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean bl = true;
                    return bl;
                }
                this.batch.add(msg, MaxOneThreadPerSender.this.resize);
                this.queued_msgs.increment();
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected boolean allowedToSubmitToThreadPool(MessageBatch msg_batch) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean bl = true;
                    return bl;
                }
                this.batch.add(msg_batch, MaxOneThreadPerSender.this.resize);
                this.queued_batches.increment();
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean workAvailable(MessageBatch msg_batch) {
            this.lock.lock();
            try {
                boolean bl;
                int num_msgs = msg_batch.transferFrom(this.batch, true);
                if (num_msgs <= 0) {
                    this.running = false;
                    bl = false;
                } else {
                    bl = true;
                }
                boolean bl2 = bl;
                return bl2;
            }
            catch (Throwable t) {
                this.running = false;
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void setRunning(boolean flag) {
            this.lock.lock();
            try {
                this.running = flag;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return String.format("batch size=%d queued msgs=%d queued batches=%d submitted msgs=%d submitted batches=%d", this.batch.size(), this.queued_msgs.sum(), this.queued_batches.sum(), this.submitted_msgs.sum(), this.submitted_batches.sum());
        }
    }
}

