/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

public class TransferQueueBundler
extends BaseBundler
implements Runnable {
    protected BlockingQueue<Message> queue;
    protected final List<Message> remove_queue = new ArrayList<Message>(16);
    protected volatile Thread bundler_thread;
    @Property(description="When the queue is full, senders will drop a message rather than wait until space is available (https://issues.redhat.com/browse/JGRP-2765)")
    protected boolean drop_when_full = true;
    protected volatile boolean running = true;
    @ManagedAttribute(description="Number of times a message was sent because the queue was full", type=AttributeType.SCALAR)
    protected long num_sends_because_full_queue;
    @ManagedAttribute(description="Number of times a message was sent because there was no message available in the queue", type=AttributeType.SCALAR)
    protected long num_sends_because_no_msgs;
    @ManagedAttribute(description="Number of dropped messages (when drop_when_full is true)", type=AttributeType.SCALAR)
    protected long num_drops_on_full_queue;
    @ManagedAttribute(description="Average fill size of the queue (in bytes)")
    protected final AverageMinMax avg_fill_count = new AverageMinMax();
    protected static final String THREAD_NAME = "TQ-Bundler";

    public TransferQueueBundler() {
    }

    protected TransferQueueBundler(BlockingQueue<Message> queue) {
        this.queue = queue;
    }

    public TransferQueueBundler(int capacity) {
        this(new ArrayBlockingQueue<Message>(Util.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    public Thread getThread() {
        return this.bundler_thread;
    }

    @Override
    @ManagedAttribute(description="Size of the queue")
    public int getQueueSize() {
        return this.queue.size();
    }

    @ManagedAttribute(description="Size of the remove-queue")
    public int removeQueueSize() {
        return this.remove_queue.size();
    }

    public boolean dropWhenFull() {
        return this.drop_when_full;
    }

    public <T extends Bundler> T dropWhenFull(boolean d) {
        this.drop_when_full = d;
        return (T)this;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_drops_on_full_queue = 0L;
        this.num_sends_because_no_msgs = 0L;
        this.num_sends_because_full_queue = 0L;
        this.avg_fill_count.clear();
    }

    @Override
    public void init(TP tp) {
        super.init(tp);
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.queue = new ArrayBlockingQueue<Message>(Util.assertPositive(this.capacity, "bundler capacity cannot be " + this.capacity));
        this.bundler_thread = this.transport.getThreadFactory().newThread(this, THREAD_NAME);
        this.running = true;
        this.bundler_thread.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.bundler_thread;
        this.bundler_thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.drain();
    }

    @Override
    public int size() {
        return super.size() + this.removeQueueSize() + this.getQueueSize();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (!this.running) {
            return;
        }
        if (this.drop_when_full || msg.isFlagSet(Message.TransientFlag.DONT_BLOCK)) {
            if (!this.queue.offer(msg)) {
                ++this.num_drops_on_full_queue;
            }
        } else {
            this.queue.put(msg);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = this.queue.take();
                if (msg == null) continue;
                this.addAndSendIfSizeExceeded(msg);
                block3: while (true) {
                    this.remove_queue.clear();
                    int num_msgs = this.queue.drainTo(this.remove_queue);
                    if (num_msgs <= 0) break;
                    int i = 0;
                    while (true) {
                        if (i >= this.remove_queue.size()) continue block3;
                        msg = this.remove_queue.get(i);
                        this.addAndSendIfSizeExceeded(msg);
                        ++i;
                    }
                    break;
                }
                if (this.count <= 0L) continue;
                ++this.num_sends_because_no_msgs;
                this.avg_fill_count.add(this.count);
                this.sendBundledMessages();
            }
            catch (Throwable t) {
                this.log.trace("%s: failed sending message: %s", this.transport.addr(), t);
            }
        }
    }

    protected void addAndSendIfSizeExceeded(Message msg) {
        int size = msg.size();
        if (this.count + (long)size > (long)this.max_size) {
            ++this.num_sends_because_full_queue;
            this.avg_fill_count.add(this.count);
            this.sendBundledMessages();
        }
        this.addMessage(msg, size);
    }

    protected void drain() {
        if (this.queue != null) {
            Message msg;
            while ((msg = (Message)this.queue.poll()) != null) {
                this.addAndSendIfSizeExceeded(msg);
            }
        }
        if (!this.msgs.isEmpty()) {
            this.sendBundledMessages();
        }
    }
}

