/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.config.HasConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;
import org.lsst.ccs.utilities.scheduler.Scheduler;

class PeriodicTaskComponent
implements HasLifecycle,
HasConfigurationParameterDescription {
    private final Random randomizer = new Random();
    private final PeriodicTaskWithScheduler task;
    private final AgentPeriodicTask agentPeriodicTask;
    protected final Object taskLock = new Object();
    protected final PeriodicTaskExceptionHandler handler;
    @ConfigurationParameter(category="timers", units="ms")
    private volatile long taskPeriodMillis = -1L;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupPath
    private String componentPath;
    private boolean hasBeenStarted = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService agentPeriodicTaskService;

    PeriodicTaskComponent(AgentPeriodicTask taskDefinition, Scheduler scheduler, AgentPeriodicTaskService.AgentPeriodicTaskExceptionHandler handler) {
        this.taskPeriodMillis = taskDefinition.getPeriod().toMillis();
        handler.setLevel(taskDefinition.getLogLevel());
        this.task = new PeriodicTaskWithScheduler(new PeriodicTask(scheduler, (Runnable)new PeriodicTaskRunnableWrapper(taskDefinition, handler), taskDefinition.isIsFixedRate(), taskDefinition.getTaskName(), this.taskPeriodMillis, TimeUnit.MILLISECONDS, (PeriodicTaskExceptionHandler)handler), scheduler);
        if (this.task == null) {
            throw new RuntimeException("The PeriodicTask cannot be null");
        }
        if (this.task.getPeriodicTask().getTaskName().isEmpty()) {
            throw new RuntimeException("The PeriodicTask cannot have an empty name");
        }
        this.agentPeriodicTask = taskDefinition;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="taskPeriodMillis")
    public void setTaskPeriodMillis(long taskPeriodMillis) {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis != taskPeriodMillis) {
                this.taskPeriodMillis = taskPeriodMillis;
                if (this.hasBeenStarted) {
                    this.task.getPeriodicTask().stop();
                    if (taskPeriodMillis > 0L) {
                        this.startTask();
                    }
                }
            }
        }
    }

    public ConfigurationParameterDescription getConfigurationParameterDescription(String parName) {
        if (parName.equals("taskPeriodMillis")) {
            return this.agentPeriodicTask.getPeriodParameterDescription();
        }
        throw new IllegalArgumentException("A PeriodicTaskComponent does not have a parameter named: " + parName);
    }

    public long getTaskPeriodMillis() {
        return this.taskPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis > 0L) {
                this.task.getPeriodicTask().setPeriod(this.taskPeriodMillis, TimeUnit.MILLISECONDS);
                long initialRandomDelay = (long)(this.randomizer.nextDouble() * (double)this.taskPeriodMillis);
                this.task.getPeriodicTask().start(initialRandomDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this.task.getPeriodicTask().stop();
        }
    }

    @Override
    public void shutdown() {
        this.stopTask();
    }

    @Override
    public void postInit() {
        List<DataProviderInfo> dpiList = this.configurationService.getDataProviderInfos();
        for (DataProviderInfo dpi : dpiList) {
            String path = dpi.getPath();
            String name = dpi.getKey();
            if (!path.equals(this.componentPath) || !name.equals("taskPeriodMillis") || dpi.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION) != null) continue;
            dpi.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "period for task " + this.agentPeriodicTask.getTaskName());
        }
    }

    @Override
    public void postStart() {
        if (this.hasBeenStarted) {
            return;
        }
        this.hasBeenStarted = true;
        this.startTask();
    }

    PeriodicTaskWithScheduler getTask() {
        return this.task;
    }

    AgentPeriodicTask getAgentPeriodicTask() {
        return this.agentPeriodicTask;
    }

    static class PeriodicTaskRunnableWrapper
    implements Runnable {
        private final AgentPeriodicTask agentPeriodicTask;
        private final AgentPeriodicTaskService.AgentPeriodicTaskExceptionHandler executionHandler;

        PeriodicTaskRunnableWrapper(AgentPeriodicTask task, AgentPeriodicTaskService.AgentPeriodicTaskExceptionHandler handler) {
            this.agentPeriodicTask = task;
            this.executionHandler = handler;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            this.agentPeriodicTask.getRunnable().run();
            long delta = System.currentTimeMillis() - start;
            this.executionHandler.onSuccessfulExecution(this.agentPeriodicTask, delta);
        }
    }

    static class PeriodicTaskWithScheduler {
        private final PeriodicTask task;
        private final Scheduler scheduler;

        PeriodicTaskWithScheduler(PeriodicTask task, Scheduler scheduler) {
            this.task = task;
            this.scheduler = scheduler;
        }

        PeriodicTask getPeriodicTask() {
            return this.task;
        }

        Scheduler getScheduler() {
            return this.scheduler;
        }
    }
}

