<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Projects</title>
    </head>



    <body>
        <h1>CCS Subsystems</h1>
        <p>
            The following is the list of CCS Subsystems.
        </p>

        <sql:query var="subsystems" dataSource = "jdbc/ccs">
            SELECT
            proj.name,
            proj.description
            FROM
            ccs_Projects proj where 
            proj.type = 'subsystem'
        </sql:query>

        <table border="0" class="table table-striped">
            <tr>
                <th>Subsystem</th>
                <th>Description</th>
            </tr>     
            <c:forEach var="subsystem" items="${subsystems.rows}">
                <tr>
                    <td>
                        <a href="projectVersions.jsp?projectName=${subsystem.name}">${subsystem.name}</a>
                    </td>
                    <td>${subsystem.description}</td>
                </tr>
            </c:forEach>
        </table>



    </body>
</html>
