<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Release Cycle</title>
    </head>

    <body>

        <h1>Release Notes</h1>
        <p>
            The following are the release Notes for release cycle <rmutils:chooseReleaseCycle/>
        </p>

        <sql:query var="desc" dataSource = "jdbc/ccs">
            select description, isToolkit from  ccs_Release_Cycle where name = ?
            <sql:param value="${displayRelCycle}" />
        </sql:query>


        <c:if test="${desc.rows[0].isToolkit==1}">
            <p>
                A list of all the compatible CCS packages can be found at the
                <a href="index.jsp?relCycle=${displayRelCycle}">Version Compatibility List</a> page.
            </p>

        </c:if>


        <h3>
            ${desc.rows[0].description}
        </h3>



        <sql:query var="results" dataSource = "jdbc/ccs">
            select pr.projectName, pr.version,
            proj.jiraProject, proj.jiraVersionPrefix, proj_disp.links, proj_disp.projectSiteLocation from ccs_Project_Version pr 
            join ccs_Release_Cycle rc on (pr.relCycle = rc.name )
            join ccs_Projects proj on (pr.projectName = proj.name)
            left outer join ccs_Project_Display proj_disp on (proj_disp.projectName = pr.projectName)
            where rc.name = ? order by proj_disp.projectOrder asc
            <sql:param value="${displayRelCycle}" />
        </sql:query>



        <c:forEach var="row" items="${results.rows}">
            <rmutils:displayProjectVersion projectHeader="<a href=\"projectVersions.jsp?projectName=${row.projectName}\">${row.projectName}</a> <a href=\"projectVersions.jsp?projectName=${row.projectName}&projectVersion=${row.version}\">${row.version}</a>" 
                                           projectVersion="${row.version}" projectJiraProject="${row.jiraProject}"                                           
                                           projectJiraPrefix="${row.jiraVersionPrefix}" 
                                           projectName="${row.projectName}"
                                           projectLinks="${row.links}" projectSiteLocation="${row.projectSiteLocation}"
                                           />
        </c:forEach>

    </body>
</html>
