<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>
<%@taglib uri="http://srs.slac.stanford.edu/time" prefix="time" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Release Cycles</title>
    </head>

    <body>

        <c:if test="${! empty param.assignRelCycle}">
            <c:set var="values" value="${fn:split(fn:escapeXml(param.assignRelCycle),'__')}"/>
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle_Versions set version = ? 
                where projectName = ? and relCycle = ?
                <sql:param value="${values[1]}"/>
                <sql:param value="${values[0]}"/>
                <sql:param value="${values[2]}"/>
            </sql:update>
            <table width="100%">
                <tr>
                    <td>
                        <table class="filterTable">
                            <tr>
                                <th>Status: </th>
                                <td style="color: green">Assigned version ${values[1]} of project ${values[0]} to <a href="releaseNotes.jsp?relCycle=${values[2]}">Release Cycle</a> ${values[2]}</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </c:if>
        
        
                
        <h2>Release Cycle Versions Edit</h2>
        <p>
            This page allows to edit package versions assigned to Release Cycles. Versions of packages that have been released in this Release Cycle cannot be edited.
        </p>

        <c:if test="${! empty param.edit}">
            <c:set var="editRelCycle" value="${fn:escapeXml(param.edit)}" scope="session"/>            
        </c:if>


        <c:choose>
            <c:when test="${! empty editRelCycle}">

                <h3>Editing Release Cycle : ${editRelCycle}</h3>
                <sql:query dataSource = "jdbc/ccs" var="relCycleVersions">
                    select rc_ver.projectName, rc_ver.version,
                    p_ver.projectName is not null and p_ver.version not like '%-SNAPSHOT' as wasReleased
                    from ccs_Release_Cycle_Versions rc_ver 
                    left outer join
                    ccs_Project_Version p_ver on
                    rc_ver.projectName = p_ver.projectName and rc_ver.relCycle = p_ver.relCycle 
                    where
                    rc_ver.relCycle = ?  
                    <sql:param value="${editRelCycle}"/>
                </sql:query>

                <form>
                    <table border="0" class="table table-striped">
                        <tr>
                            <th>Project Name</th>
                            <th>Version</th>
                        </tr>     
                        <c:forEach var="row" items="${relCycleVersions.rows}">
                            <tr>
                                <td>${row.projectName}</td>
                                <td>
                                    <c:choose>
                                        <c:when test="${row.wasReleased == 1}">
                                            ${row.version}
                                        </c:when>
                                        <c:otherwise>
                                            <sql:query dataSource = "jdbc/ccs" var="projVersions">
                                                select * from 
                                                ccs_Project_Version p_ver 
                                                where
                                                p_ver.projectName = ?
                                                order by created desc 
                                                <sql:param value="${row.projectName}"/>
                                            </sql:query>
                                            <select onchange="assignRelCycle(this)">
                                                <c:forEach items="${projVersions.rows}" var="projVer">
                                                    <option <c:if test="${row.version == projVer.version}">selected</c:if> value="${row.projectName}__${projVer.version}__${editRelCycle}">${projVer.version}</option>
                                                </c:forEach>
                                            </select>
                                        </c:otherwise>
                                    </c:choose>
                                </td>
                            </tr>     
                        </c:forEach>
                    </table>                
                </form>


            </c:when>
            <c:otherwise>
                Please choose a Release Cycle to edit from the <a href="releaseCyclesAdmin.jsp">list of Release Cycles</a>.
            </c:otherwise>
        </c:choose>
    </body>
</html>
