<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Release Cycles</title>
    </head>

    <body>

        <h2>Release Cycles</h2>
        <p>
            The following is a list of the release cycles of CCS Code.
        </p>

        <h4>Upcoming Releases</h4>
        <sql:query var="r_cycles" dataSource = "jdbc/ccs">
            select * from ccs_Release_Cycle where released = 0 and archived = 0 order by date desc
        </sql:query>

        <table border="0" class="table table-striped">
            <tr>
                <th>Release Cycle</th>
                <th>Description</th>
                <th>Release Date</th>
                <th>Links</th>
            </tr>     
            <c:forEach var="rel_cycle" items="${r_cycles.rows}">
                <tr>
                    <td>${rel_cycle.name}</td>
                    <td>${rel_cycle.description}</td>
                    <td>${rel_cycle.date}</td>
                    <td><a href="releaseNotes.jsp?relCycle=${rel_cycle.name}">Release Notes</a> <c:if test="${rel_cycle.isToolkit == 1}">| <a href="index.jsp?relCycle=${rel_cycle.name}">Compatible Versions</a></c:if></td>
                </tr>     
            </c:forEach>
        </table>
            
        <h4>Archived Releases</h4>
            
        <sql:query var="r_cycles" dataSource = "jdbc/ccs">
            select * from ccs_Release_Cycle where archived = 1 order by date desc
        </sql:query>
            
        <table border="0" class="table table-striped">
            <tr>
                <th>Release Cycle</th>
                <th>Description</th>
                <th>Release Date</th>
                <th>Links</th>
            </tr>     
            <c:forEach var="rel_cycle" items="${r_cycles.rows}">
                <tr>
                    <td>${rel_cycle.name}</td>
                    <td>${rel_cycle.description}</td>
                    <td>${rel_cycle.date}</td>
                    <td><a href="releaseNotes.jsp?relCycle=${rel_cycle.name}">Release Notes</a> <c:if test="${rel_cycle.isToolkit == 1}">| <a href="index.jsp?relCycle=${rel_cycle.name}">Compatible Versions</a></c:if></td>
                </tr>     
            </c:forEach>
        </table>

    </body>
</html>
