<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/WEB-INF/releaseManagement.tld" prefix="rm" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Project Releases</title>
    </head>

    <body>
        <h2><a href="projectVersions.jsp?projectName=${fn:escapeXml(param.projectName)}">${fn:escapeXml(param.projectName)}</a></h2>

        <c:set var="version" value="${fn:escapeXml(param.projectVersion)}"/>


        <sql:query var="p_snapshots" dataSource = "jdbc/ccs">
            select psnap.projectName, psnap.version, proj.jiraProject, proj.jiraVersionPrefix, 
            proj_dis.projectSiteLocation, proj_dis.links from ccs_Project_Version psnap 
            join ccs_Projects proj on (proj.name = psnap.projectName)
            join ccs_Project_Display proj_dis on (proj_dis.projectName = psnap.projectName)
            where psnap.projectName = ? and psnap.isSnapshot = 1
            <c:if test="${! empty version}">
                and psnap.version = ?
            </c:if>
            order by created desc
            <sql:param value="${fn:escapeXml(param.projectName)}"/>
            <c:if test="${! empty version}">
                <sql:param value="${version}"/>
            </c:if>
        </sql:query>

        <c:if test="${p_snapshots.rowCount > 0 }">
            <h3>Snapshots</h3>
        </c:if>
        <c:forEach var="proj_snapshot" items="${p_snapshots.rows}">
        <rmutils:displayProjectVersion projectVersion="${proj_snapshot.version}" projectJiraProject="${proj_snapshot.jiraProject}"
                                       projectJiraPrefix="${proj_snapshot.jiraVersionPrefix}" projectName="${proj_snapshot.projectName}"
                                       projectLinks="${proj_snapshot.links}" projectSiteLocation="${proj_snapshot.projectSiteLocation}" />

    </c:forEach>


    <sql:query var="p_releases" dataSource = "jdbc/ccs">
        select prel.projectName, prel.version, proj.jiraProject, proj.jiraVersionPrefix, prel.relcycle, 
        proj_dis.projectSiteLocation, proj_dis.links from ccs_Project_Version prel 
        join ccs_Projects proj on (proj.name = prel.projectName)
        join ccs_Project_Display proj_dis on (proj_dis.projectName = prel.projectName)
        where prel.projectName = ? and prel.isSnapshot = 0
        <c:if test="${! empty version}">
            and prel.version = ?
        </c:if>
        order by created desc
        <sql:param value="${fn:escapeXml(param.projectName)}"/>
        <c:if test="${! empty version}">
            <sql:param value="${version}"/>
        </c:if>
    </sql:query>

    <c:if test="${p_releases.rowCount > 0 }">
        <h3>Releases</h3>
    </c:if>
    <c:forEach var="proj_release" items="${p_releases.rows}">
        <rmutils:displayProjectVersion projectVersion="${proj_release.version}" projectJiraProject="${proj_release.jiraProject}"
                                       projectJiraPrefix="${proj_release.jiraVersionPrefix}" relCycle="${proj_release.relcycle}"
                                       projectName="${proj_release.projectName}"
                                       projectLinks="${proj_release.links}" projectSiteLocation="${proj_release.projectSiteLocation}"
                                       />
    </c:forEach>





</body>
</html>
