<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Projects</title>
    </head>



    <body>
        <h1>CCS Drivers</h1>
        <p>
            The following is the list of CCS Drivers.
        </p>

        <sql:query var="drivers" dataSource = "jdbc/ccs">
            SELECT
            proj.name,
            proj.longDescription
            FROM
            ccs_Projects proj where 
            proj.type = 'driver'
        </sql:query>

        <table border="0" class="table table-striped">
            <tr>
                <th>Driver</th>
                <th>Description</th>
            </tr>     
            <c:forEach var="driver" items="${drivers.rows}">
                <tr>
                    <td> 
                        <a href="projectVersions.jsp?projectName=${driver.name}">${fn:replace(driver.name,'org-lsst-ccs-drivers-','')}</a>
                    </td>
                    <td>${driver.longDescription}</td>
                </tr>
            </c:forEach>
        </table>



    </body>
</html>
