<%@tag description="Project Links" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/releaseManagement.tld" prefix="rm" %> 
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<%@ attribute name="projectVersion" required="true" %>
<%@ attribute name="projectName" required="true" %>
<%@ attribute name="projectLinks" required="true" %>
<%@ attribute name="projectSiteLocation" required="true" %>
<%@ attribute name="projectJiraProject" required="false" %>
<%@ attribute name="projectJiraPrefix" required="false" %>
<%@ attribute name="relCycle" required="false" %>
<%@ attribute name="projectHeader" required="false" %>

<c:if test="${empty projectHeader}">
    <c:set var="projectHeader" value="<a href=\"projectVersions.jsp?projectName=${projectName}&projectVersion=${projectVersion}\">${projectVersion}</a>"/>
</c:if>


<h4>${projectHeader}</h4>
<c:if test="${! empty relCycle}">
    <p>Part of release cycle <a href="releaseCycles.jsp">${relCycle}</a></p>
</c:if>
<table border="0" class="table table-striped">
    <rmutils:displayProjectInfoRow projectVersion="${projectVersion}" projectName="${projectName}"
                                   projectLinks="${projectLinks}" projectSiteLocation="${projectSiteLocation}" />                                   
</table>

<c:if test="${! empty projectJiraProject}">
    <c:if test="${! empty projectJiraPrefix}">
        <c:set var="jiraVersion" value="${projectJiraPrefix}-"/>
    </c:if>
    <c:set var="jiraVersion" value="${jiraVersion}${projectVersion}"/>
    <c:set var="jiraVersion" value="${fn:replace(jiraVersion,'-SNAPSHOT','')}"/>
    <c:set var="jiras" value="${rm:getJiraIssues(projectJiraProject, jiraVersion)}"/>

    <p>
        List of Jiras for version <a href="https://jira.slac.stanford.edu/issues/?jql=project+%3D+${projectJiraProject}+AND+fixVersion+%3D+%22${jiraVersion}%22">${jiraVersion}</a>
    </p>
    <c:choose>
        <c:when test="${! empty jiras}">
            <table border="0" class="table table-striped">
                <tr>
                    <th>Type</th>
                    <th>Key</th>
                    <th>Summary</th>
                    <th>Priority</th>
                    <th>Status</th>
                    <th>Resolution</th>                            
                </tr>     
                <c:forEach var="issue" items="${jiras}">
                    <tr>
                        <td><img src="${issue.typeIconUrl}"/></td>
                        <td><a href="https://jira.slac.stanford.edu/browse/${issue.key}">${issue.key}</a></td>
                        <td><a href="https://jira.slac.stanford.edu/browse/${issue.key}">${issue.summary}</a></td>
                        <td><img src="${issue.priorityIconUrl}"/></td>
                        <td>${issue.status}</td>
                        <td>${issue.resolution}</td>                            
                    </tr>     
                </c:forEach>
            </table>
        </c:when>
        <c:otherwise>
            No Jira Issues could be found.
        </c:otherwise>                    
    </c:choose>
</c:if>

