/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.release.management;

import org.json.JSONException;
import org.json.JSONObject;

public class JiraIssue {
    private String typeIconUrl;
    private String key;
    private String summary;
    private String priorityIconUrl;
    private String status;
    private String resolution = "Unresolved";

    public JiraIssue(JSONObject jsonObj) throws JSONException {
        this.key = jsonObj.getString("key");
        JSONObject fields = jsonObj.getJSONObject("fields");
        this.summary = fields.getString("summary");
        JSONObject type = fields.getJSONObject("issuetype");
        this.typeIconUrl = type.getString("iconUrl");
        try {
            JSONObject relObject = fields.getJSONObject("resolution");
            if (relObject != null) {
                this.resolution = relObject.getString("name");
            }
        }
        catch (JSONException relObject) {
            // empty catch block
        }
        JSONObject priority = fields.getJSONObject("priority");
        this.priorityIconUrl = priority.getString("iconUrl");
        this.status = fields.getJSONObject("status").getString("name");
    }

    public String getTypeIconUrl() {
        return this.typeIconUrl;
    }

    public String getKey() {
        return this.key;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getPriorityIconUrl() {
        return this.priorityIconUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }
}

