<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Project Versions Admin</title>
    </head>

    <body>

        <c:if test="${! empty param.assignRelCycle}">
            <c:set var="values" value="${fn:split(param.assignRelCycle,'__')}"/>
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Project_Version set relCycle = ?
                where projectName = ? and version = ?
                <sql:param value="${values[2]}"/>
                <sql:param value="${values[0]}"/>
                <sql:param value="${values[1]}"/>
            </sql:update>
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle_Versions set version = ?
                where projectName = ? and relCycle = ?
                <sql:param value="${values[1]}"/>
                <sql:param value="${values[0]}"/>
                <sql:param value="${values[2]}"/>
            </sql:update>
            <table width="100%">
                <tr>
                    <td>
                        <table class="filterTable">
                            <tr>
                                <th>Status: </th>
                                <td style="color: green">Assigned version ${values[1]} of project ${values[0]} to <a href="releaseNotes.jsp?relCycle=${values[2]}">Release Cycle</a> ${values[2]}</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </c:if>


        <h2>Unassigned Project Versions</h2>

        <p>
            The following is a list of versions that are not assigned to any of the upcoming Release Cycles. Use the form below to assign them to the appropriate Release Cycle.
        </p>

        <sql:query var="upcoming_rel_cycle" dataSource = "jdbc/ccs">
            select * from ccs_Release_Cycle where released = 0
        </sql:query>

        <sql:query var="unclaimed_versions" dataSource = "jdbc/ccs">
            select * from ccs_Project_Version where relCycle is null
        </sql:query>

        <form>
            <table border="0" class="table table-striped">
                <tr>
                    <th>Project Name</th>
                    <th>Version</th>
                    <th>Release Cycle</th>
                </tr>     
                <c:forEach var="row" items="${unclaimed_versions.rows}">
                    <tr>
                        <td>${row.projectName}</td>
                        <td>${row.version}</td>
                        <td>
                            <select onchange="assignRelCycle(this)">
                                <option selected></option>
                                <c:forEach items="${upcoming_rel_cycle.rows}" var="relCycle">
                                    <option value="${row.projectName}__${row.version}__${relCycle.name}">${relCycle.name}</option>
                                </c:forEach>
                            </select>
                        </td>
                    </tr>     
                </c:forEach>
            </table>                
        </form>


    </body>
</html>
