<%@tag description="Project Links" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/releaseManagement.tld" prefix="rm" %> 
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>

<%@ attribute name="projectType" required="true" %>
<%@ attribute name="relCycle" required="true" %>
<%@ attribute name="showDescription" required="false" %>

<c:if test="${empty showDescription}">
    <c:set var="showDescription" value="true"/>
</c:if>


<sql:query var="projects" dataSource = "jdbc/ccs">
    SELECT
    proj_version.projectName,
    proj_version.version,
    proj.jiraProject,
    proj.jiraVersionPrefix,
    proj_dis.projectSiteLocation,
    proj_dis.links,
    proj.description,
    proj_dis.projectOrder,
    p_ver.projectName is not null and p_ver.version not like '%-SNAPSHOT' as wasReleased
    FROM
    ccs_Release_Cycle_Versions proj_version
    JOIN
    ccs_Projects proj
    ON
    (
    proj.name = proj_version.projectName)
    JOIN
    ccs_Project_Display proj_dis
    ON
    (
    proj_dis.projectName = proj_version.projectName)
    left outer join ccs_Project_Version p_ver 
    on (p_ver.projectName = proj.name and p_ver.relCycle = proj_version.relCycle)
    WHERE
    proj.type = ?  and proj_version.relCycle = ?
    UNION
    SELECT
    proj_mod.moduleName,
    proj_version.version,
    proj.jiraProject,
    proj.jiraVersionPrefix,
    proj_dis.projectSiteLocation,
    proj_dis.links,
    proj.description,
    proj_dis.projectOrder,
    p_ver.projectName is not null and p_ver.version not like '%-SNAPSHOT' as wasReleased
    FROM
    ccs_Project_Modules proj_mod
    JOIN ccs_Release_Cycle_Versions proj_version on (proj_mod.projectName = proj_version.projectName)
    JOIN
    ccs_Projects proj
    ON
    (
    proj.name = proj_mod.moduleName)
    JOIN
    ccs_Project_Display proj_dis
    ON
    (
    proj_dis.projectName = proj_mod.moduleName)
    left outer join ccs_Project_Version p_ver 
    on (p_ver.projectName = proj_mod.projectName and p_ver.relCycle = proj_version.relCycle)
    WHERE
    proj.type = ? and proj_version.relCycle = ?
    ORDER BY
    projectOrder ASC
    <sql:param value="${projectType}"/>
    <sql:param value="${relCycle}"/>
    <sql:param value="${projectType}"/>
    <sql:param value="${relCycle}"/>
</sql:query>



<table border="0" class="table table-striped">
    <tr>
        <th>Pom Project</th>
            <c:if test="${showDescription}">
            <th>Description</th>        
            </c:if>
        <th>Version</th>
        <th>Available Reports</th>
    </tr>     
    <c:forEach var="project" items="${projects.rows}">

        <rmutils:displayProjectInfoRow projectVersion="${project.version}" projectName="${project.projectName}"
                                       projectLinks="${project.links}" projectSiteLocation="${project.projectSiteLocation}"
                                       projectDescription="${project.description}" showProject="true" showVersion="true"
                                       showDescription="${showDescription}" wasReleased="${ project.wasReleased == 1}"/>                                   


    </c:forEach>

</table>

