<%@tag description="Project Links" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/releaseManagement.tld" prefix="rm" %> 
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<%@ attribute name="projectLinks" required="true" %>
<%@ attribute name="projectSiteLocation" required="true" %>
<%@ attribute name="projectVersion" required="true" %>
<%@ attribute name="projectName" required="true" %>
<%@ attribute name="projectDescription" required="false" %>
<%@ attribute name="showVersion" required="false"  %>
<%@ attribute name="showProject" required="false"  %>
<%@ attribute name="showDescription" required="false" %>
<%@ attribute name="wasReleased" required="false" %>

<c:if test="${empty showVersion}">
    <c:set var="showVersion" value="false"/>
</c:if>
<c:if test="${empty showProject}">
    <c:set var="showProject" value="false"/>
</c:if>


<c:set var="colSpan" value="2"/>
<c:if test="${showDescription}">

    <c:set var="colSpan" value="${colSpan + 1}"/>
</c:if>
<c:if test="${showVersion}">
    <c:set var="colSpan" value="${colSpan + 1}"/>
</c:if>


<sql:query var="modules" dataSource = "jdbc/ccs">
    select p_mod.moduleName, p.name, p_dis.links,
    p_dis.projectSiteLocation, p_dis.displayasmodule from ccs_Project_Modules p_mod
    join ccs_Projects p on (p.name = p_mod.projectName)
    join ccs_Project_Display p_dis on (p_dis.projectName = p_mod.moduleName)
    where p_mod.projectName = ?
    order by p_dis.projectOrder asc
    <sql:param value="${projectName}"/>    
</sql:query>



<tr>
    <td>
        <c:if test="${fn:length(modules.rows)>0}">
            <img onclick="showHide(this, '${projectName}')" src="./images/expand.png" alt="" />
        </c:if>
        <c:if test="${showProject}">
            <a href="projectVersions.jsp?projectName=${projectName}">${projectName}<c:if test="${wasReleased}"><font style="color: red">*</font></c:if></a>
        </c:if>

    </td>
    <c:if test="${showDescription}">
        <td>
            ${projectDescription}
        </td>        
    </c:if>
    <c:if test="${showVersion}">
        <td>
            <a href="projectVersions.jsp?projectName=${projectName}&projectVersion=${projectVersion}">${projectVersion}</a>
        </td>
    </c:if>
<rmutils:displayProjectDocLinks projectLinks="${projectLinks}" projectName="${projectName}" projectVersion="${projectVersion}" projectSiteLocation="${projectSiteLocation}/${projectName}/${projectVersion}" />

</tr>
<c:if test="${fn:length(modules.rows)>0}">
    <tr style="display:none" id="${projectName}">                
        <td colspan="${colSpan}">
            <table border="0" class="table table-striped">
                <c:forEach var="module" items="${modules.rows}">
                    <tr>
                        <td>
                            ${module.moduleName}
                        </td>
                        <c:choose>
                            <c:when test="${module.displayasmodule}">
                    <rmutils:displayProjectDocLinks projectLinks="${module.links}" projectName="${module.moduleName}" projectVersion="${projectVersion}" projectSiteLocation="${projectSiteLocation}/${projectName}/${projectVersion}/${module.projectSiteLocation}" />                                        
                            </c:when>
                            <c:otherwise>
                    <rmutils:displayProjectDocLinks projectLinks="${module.links}" projectName="${module.moduleName}" projectVersion="${projectVersion}" projectSiteLocation="${module.projectSiteLocation}/${module.moduleName}/${projectVersion}" />                                                                        
                            </c:otherwise>
                        </c:choose>
        </tr>
    </c:forEach>       
</table>    
</td>
</tr>
<tr style="display:none" >                
    <td colspan="${colSpan}">
    </td>
</tr>
</c:if>
