<%@tag description="Project Links" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>

<%@ attribute name="inForm" required="false" %>
<%@ attribute name="toolkitOnly" required="false" %>



<sql:query var="relCycles" dataSource = "jdbc/ccs">
    select * from ccs_Release_Cycle where archived = 0
    <c:if test="${toolkitOnly}">
        and isToolkit = 1
    </c:if>
    order by released asc,  date desc
</sql:query>


<c:if test="${! empty param.relCycle}" >
    <c:set var="displayRelCycle" value="${fn:escapeXml(param.relCycle)}" scope="session"/>
</c:if>
<c:if test="${empty displayRelCycle}" >


    <c:set var="displayRelCycle" value="${relCycles.rows[0].name}" scope="session"/>
</c:if>


<select  name="selectedRelCycle" <c:if test="${empty inForm}"> onchange="changeRelCycle(this)" </c:if>>
        <option disabled ><b>--- Upcoming Release Cycles ---</b></option>

<c:forEach items="${relCycles.rows}" var="r_cycle">

    <c:if test="${released}">
        <c:set var="done" value="true"/>
    </c:if>
    <c:set var="released" value="false"/>                

    <c:if test="${r_cycle.released == 1 && ! done}">
        <c:set var="released" value="true"/>                
    </c:if>

    <c:set var="selected" value="${r_cycle.name == displayRelCycle}"/>

    <c:if test="${released}">
        <option disabled ><b>--- Completed Release Cycles ---</b></option>        
    </c:if>
<option  value="${r_cycle.name}" <c:if test="${selected}">selected</c:if>>${r_cycle.name}</option>            
</c:forEach>
</select>            




