package org.lsst.ccs.release.management;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;

/**
 *
 * @author turri
 */
public class JiraVersionManagement {

    private static String jiraIssuesRequestParameter = "fixVersion=\"{0}\"&project={1}";

    private static WebTarget jiraRestWebTarget = null;

    private static MultivaluedMap<String, Object> jiraHeaders = new MultivaluedHashMap<>();
    static {
        jiraHeaders.add("Content-Type", "application/json");
        jiraHeaders.add("Authorization", "Bearer Mzc0NTg4MzcwOTMzOuv1pr+yDq2MeZL0o23LcPZ+tEXB");
    }
    

    private static WebTarget getJiraRestWebTarget() {
        if (jiraRestWebTarget == null) {
            Client client = ClientBuilder.newBuilder().newClient(new ClientConfig());
//            client.register(new LoggingFilter());

            jiraRestWebTarget = client.target("https://jira.slac.stanford.edu/rest/api/2/");
        }
        return jiraRestWebTarget;
    }

    public static List<JiraIssue> getJiraIssues(String jiraProject, String jiraVersion) throws IOException {

        ArrayList<JiraIssue> jiraIssues = new ArrayList<>();
        WebTarget search = getJiraRestWebTarget().path("search");
        Response r = search.queryParam("jql", MessageFormat.format(jiraIssuesRequestParameter, jiraVersion, jiraProject)).request().headers(jiraHeaders).get();
        String sResult = r.readEntity(String.class);
        try {
            JSONObject result = new JSONObject(sResult);
            JSONArray issues = (JSONArray) result.get("issues");
            for (int i = 0; i < issues.length(); i++) {
                JSONObject issue = issues.getJSONObject(i);
                jiraIssues.add(new JiraIssue(issue));
            }
        } catch (JSONException ex) {
            Logger.getLogger(JiraVersionManagement.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jiraIssues;

    }

    private static String getNewJiraVersionPayload(String jiraVersionName, String projectId) {
        return "{\"name\": \"" + jiraVersionName + "\",\"archived\": false,\"released\": false,\"projectId\": \"" + projectId + "\" }";
    }

    private static String getReleaseJiraVersionPayload(String jiraVersionName, String projectId, String newJiraId) {
        return "{\"name\": \"" + jiraVersionName + "\",\"archived\": false,\"released\": true,\"projectId\": \"" + projectId
                + "\",\"moveUnfixedIssuesTo\": \"" + newJiraId + "\",\"userReleaseDate\": \"" + new SimpleDateFormat("dd/MMM/yy").format(new Date()) + "\"  }";
    }

    public static void updateJiraVersions(String jiraProject, String releasedJiraVersion, String snapshotJiraVersion) throws JSONException {

        if (jiraProject != null && !jiraProject.equals("")) {
            //First get Id for version and project        
            WebTarget project = getJiraRestWebTarget().path("project/" + jiraProject);
            Response r = project.request().headers(jiraHeaders).get();
            String sResult = r.readEntity(String.class);
            String projectId = null;
            JSONArray versions = null;
            try {
                JSONObject result = new JSONObject(sResult);
                projectId = result.getString("id");
                versions = (JSONArray) result.get("versions");
            } catch (JSONException ex) {
                Logger.getLogger(JiraVersionManagement.class.getName()).log(Level.SEVERE, null, ex);
            }

            if (projectId == null) {
                throw new RuntimeException("Could not find ID for project " + jiraProject);
            }

            JSONObject snapshotVersionJiraJson = null;
            if (snapshotJiraVersion != null && !snapshotJiraVersion.equals("")) {
                snapshotJiraVersion = snapshotJiraVersion.replace("-SNAPSHOT", "");
                WebTarget newVersion = getJiraRestWebTarget().path("version");
                snapshotVersionJiraJson = getVersionJson(versions, snapshotJiraVersion);

                //If the SNAPSHOT Jira version does not exist, creat it.
                if (snapshotVersionJiraJson == null) {
                    Response rNewVersion = newVersion.request().headers(jiraHeaders).accept(MediaType.APPLICATION_JSON)
                            .post(Entity.entity(getNewJiraVersionPayload(snapshotJiraVersion, projectId), MediaType.APPLICATION_JSON), Response.class);
                    String newVersionResult = rNewVersion.readEntity(String.class);
                    snapshotVersionJiraJson = new JSONObject(newVersionResult);
                }
            }

            if (releasedJiraVersion != null && !releasedJiraVersion.equals("")) {

                JSONObject releasedVersionJiraJson = getVersionJson(versions, releasedJiraVersion);
                // Do something only if the Jira version exists:
                if (releasedVersionJiraJson != null) {

                    //Check if the old version has already been released:
                    if (!releasedVersionJiraJson.getString("released").equals("true")) {

                        WebTarget oldVersion = getJiraRestWebTarget().path("version/" + releasedVersionJiraJson.getString("id"));

                        Response rOldVersion = oldVersion.request().headers(jiraHeaders).accept(MediaType.APPLICATION_JSON)
                                .put(Entity.json(getReleaseJiraVersionPayload(releasedJiraVersion, projectId, snapshotVersionJiraJson.getString("id"))));
                    }
                }
            }

        }
    }

    private static JSONObject getVersionJson(JSONArray versions, String versionName) throws JSONException {
        for (int i = 0; i < versions.length(); i++) {
            JSONObject version = versions.getJSONObject(i);
            if (versionName.equals(version.getString("name"))) {
                return version;
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {

//        initialized = true;
//        username = "";
//        password = "";
        
        List<JiraIssue> issues = getJiraIssues("LSSTCCS", "core-4.5.0");
        System.out.println("Issues for core 3.0.2");
        for ( JiraIssue issue : issues ) {
            System.out.println(issue.getKey()+" "+issue.getResolution());
        }
        
        updateJiraVersions("LSSTCCS", "core-3.0.2", "core-3.1.0");

        issues = getJiraIssues("LSSTCCS", "core-3.1.0");
        System.out.println("Issues for core 3.1.0");
        for ( JiraIssue issue : issues ) {
            System.out.println(issue.getKey()+" "+issue.getResolution());
        }

    }

}
