package org.lsst.ccs.project.management;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/**
 *
 * @author turri
 */
public class CheckProjects {

    /**
     * @param args the command line arguments
     * @throws java.io.IOException
     * @throws java.lang.InterruptedException
     */
    public static void main(String[] args) throws IOException, InterruptedException, DocumentException {

        Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "svn ls svn+ssh://repo-nexus.lsst.org/camera/CameraControl"});
        p.waitFor();

        InputStreamReader isr = new InputStreamReader(p.getInputStream());
        BufferedReader buff = new BufferedReader(isr);

        ArrayList<String> projects = new ArrayList<>();
        String line;
        while ((line = buff.readLine()) != null) {
            if ( line.startsWith("org-lsst") ) {
                projects.add(line.replace("/", ""));
            }
        }

//        System.out.println("*** Found "+projects.size()+" CCS projects");
        
        
        URL url = new URL("https://srs.slac.stanford.edu/hudson/api/xml");
        Document dom = new SAXReader().read(url);

        // scan through the job list and print its status
        for( Element job : (List<Element>)dom.getRootElement().elements("job")) {
            String projectName = job.elementText("name");
            projects.remove(projectName);
        }
        
        System.out.println("Projects without a Jenkins job: "+projects.size());
        for ( String missing : projects ) {
            System.out.println("*** "+missing);
        }
               
        
    }

}
