<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/releaseManagement.tld" prefix="rm" %> 

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Add Release</title>
    </head>

    <body>

        <c:set var="projectName" value="${fn:escapeXml(param.projectName)}"/>
        <c:set var="releaseVersion" value="${fn:escapeXml(param.releaseVersion)}"/>
        <c:set var="snapshotVersion" value="${fn:escapeXml(param.snapshotVersion)}"/>

        <c:if test="${!empty projectName}">
            <%-- Check if the Package already exist, if not, create it --%>
            <c:catch var="e2">
                <sql:update dataSource = "jdbc/ccs">
                    insert into ccs_Projects (name) values (?)
                    <sql:param value="${projectName}"/>
                </sql:update>
            </c:catch>

            <%-- Check if it's a release Cyle --%>
            <c:if test="${! empty releaseVersion}">
                <c:set var="releaseCycle" value="${fn:escapeXml(param.releaseCycle)}"/>
                <c:if test="${empty releaseCycle}">
                    <sql:query var="active_r_cycle" dataSource = "jdbc/ccs">
                        select * from ccs_Release_Cycle where released = 0 and active = 1
                    </sql:query>

                    <c:if test="${active_r_cycle.rowCount > 0}">
                        <c:set var="releaseCycle" value="${active_r_cycle.rows[0].name}"/>                    
                    </c:if>
                </c:if>


                <%-- Add the version to the Project_Version table --%>
                <sql:update dataSource = "jdbc/ccs">
                    insert into ccs_Project_Version (projectName,version,created,isSnapshot) values (?,?,(select current_timestamp from dual),0)
                    <sql:param value="${projectName}"/>
                    <sql:param value="${releaseVersion}"/>
                </sql:update>

                <%-- Remove released version from the Project_Version table --%>
                <sql:update dataSource = "jdbc/ccs">
                    delete from ccs_Project_Version where projectName = ? and version = ?
                    <sql:param value="${projectName}"/>
                    <sql:param value="${releaseVersion}-SNAPSHOT"/>
                </sql:update>


                <%-- If the release Cycle is not empty --%>
                <c:if test="${! empty releaseCycle}">
                    <%-- Update the package version in the ccs_Release_Cycle_Versions table --%>
                    <sql:update dataSource = "jdbc/ccs">
                        update ccs_Release_Cycle_Versions set version = ?
                        where projectName = ? and relCycle = ? 
                        <sql:param value="${releaseVersion}"/>
                        <sql:param value="${projectName}"/>
                        <sql:param value="${releaseCycle}"/>
                    </sql:update>
                    <%-- Update the relCycle in the Project_Version table --%>
                    <sql:update dataSource = "jdbc/ccs">
                        update ccs_Project_Version set relCycle = ? where projectName = ? and version = ?
                        <sql:param value="${releaseCycle}"/>
                        <sql:param value="${projectName}"/>
                        <sql:param value="${releaseVersion}"/>
                    </sql:update>
                </c:if>


            </c:if>

            <c:if test="${! empty snapshotVersion}">
                <%-- Add the next Snapshot to the Project_Version table: it might already exist--%>
                <c:catch var="e3">
                    <sql:update dataSource = "jdbc/ccs">
                        insert into ccs_Project_Version (projectName,version,created) values (?,?,(select current_timestamp from dual))
                        <sql:param value="${projectName}"/>
                        <sql:param value="${snapshotVersion}"/>
                    </sql:update>
                </c:catch>
            </c:if>



            <sql:query var="jiraInfoResult" dataSource = "jdbc/ccs">
                select jiraProject, jiraVersionPrefix from ccs_Projects where name = ?
                <sql:param value="${projectName}"/>
            </sql:query>
            <c:set var="jiraInfoRow" value="${jiraInfoResult.rows[0]}"/>
            <c:if test="${! empty jiraInfoRow}">
                <c:if test="${! empty jiraInfoRow.jiraProject}">
                    <c:set var="snapshotVersion" value="${fn:replace(snapshotVersion,'-SNAPSHOT','')}"/>
                    <c:if test="${! empty jiraInfoRow.jiraVersionPrefix}">
                        <c:set var="snapshotVersion" value="${jiraInfoRow.jiraVersionPrefix}-${snapshotVersion}"/>                        
                        <c:set var="releaseVersion" value="${jiraInfoRow.jiraVersionPrefix}-${releaseVersion}"/>                        
                    </c:if>
                    ${rm:updateJiraVersions(jiraInfoRow.jiraProject,releaseVersion,snapshotVersion)};
                </c:if>
            </c:if>



        </c:if>        

    </body>
</html>
