<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>
<%@taglib uri="http://srs.slac.stanford.edu/time" prefix="time" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Release Cycles</title>
    </head>

    <body>


        <c:if test="${! empty param.deactivate}">
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle set active = 0 where name = ?
                <sql:param value="${fn:escapeXml(param.deactivate)}"/>
            </sql:update>
        </c:if>
        <c:if test="${! empty param.activate}">
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle set active = 0
            </sql:update>
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle set active = 1 where name = ?
                <sql:param value="${fn:escapeXml(param.activate)}"/>
            </sql:update>
        </c:if>
        <c:if test="${! empty param.complete}">
            <sql:update dataSource = "jdbc/ccs">
                update ccs_Release_Cycle set active = 0, released = 1 where name = ?
                <sql:param value="${fn:escapeXml(param.complete)}"/>
            </sql:update>
        </c:if>

        <c:if test="${! empty param.createNewRelCycle}">
            <c:choose>
                <c:when test="${empty param.relCycleName}">
                    <table width="100%">
                        <tr>
                            <td>
                                <table class="filterTable">
                                    <tr>
                                        <th>Status: </th>
                                        <td style="color: red">A Release Cycle Name must be provided</td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </c:when>
                <c:otherwise>
                    <c:catch var="error">
                        <sql:update dataSource = "jdbc/ccs">
                            INSERT
                            INTO
                            ccs_Release_Cycle (name, description, date, isToolkit) values (?,?,?,?)
                            <sql:param value="${fn:escapeXml(param.relCycleName)}"/>
                            <sql:param value="${fn:escapeXml(param.relCycleDescription)}"/>
                            <sql:param value="${fn:escapeXml(param.relCycleTargetDateDate)}"/>
                            <sql:param value="${empty param.isToolkit ? 0 : 1}"/>
                        </sql:update>
                        <c:if test="${! empty param.isToolkit}">                                
                            <sql:update dataSource = "jdbc/ccs">
                                INSERT
                                INTO
                                ccs_Release_Cycle_Versions
                                (
                                relCycle,
                                projectName,
                                version
                                )

                                SELECT
                                '${fn:escapeXml(param.relCycleName)}',
                                ver.projectName,
                                ver.version
                                FROM
                                ccs_Release_Cycle_Versions ver
                                WHERE
                                ver.relCycle = (select name from ccs_Release_Cycle where isToolkit = 1 order by date desc limit 1)
                            </sql:update>
                        </c:if>

                        <table width="100%">
                            <tr>
                                <td>
                                    <table class="filterTable">
                                        <tr>
                                            <th>Status: </th>
                                            <td style="color: green">Successfully created new release cycle <b>${fn:escapeXml(param.relCycleName)}</b>.</td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>                                

                    </c:catch>
                    <c:if test="${! empty error}">
                        <table width="100%">
                            <tr>
                                <td>
                                    <table class="filterTable">
                                        <tr>
                                            <th>Status: </th>
                                            <td style="color: red">Could not create the new Release Cycle ${fn:escapeXml(param.relCycleName)}: ${error}</td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>                                
                    </c:if>


                </c:otherwise>
            </c:choose>
        </c:if>



        <h2>Release Cycles Administration</h2>


        <h4>Upcoming Release Cycles</h4>

        <p>
            Upcoming Release Cycles are still open and package releases can be assigned to them. To close a Release Cycle click on the <b>Mark as Complete</b> link below.
        </p>
        <p>
            When a release is <b>Active</b>, any CCS package release will be assigned to it. To activate/deactivate a Release Cycle click on the corresponding links below.
            Only Release Cycles that have not been marked as <b>completed</b> can be activated.
        </p>

        <sql:query var="active_r_cycle" dataSource = "jdbc/ccs">
            select * from ccs_Release_Cycle where released = 0 and active = 1
        </sql:query>

        <c:choose>
            <c:when test="${active_r_cycle.rowCount > 0}">
                <c:set var="activeRelCycle" value="<b>${active_r_cycle.rows[0].name}</b>"/>                    
            </c:when>
            <c:otherwise>
                <c:set var="activeRelCycle" value="No Release Cycle is currently active"/>                                        
            </c:otherwise>
        </c:choose>
        <p>
            Currently active: ${activeRelCycle}
        </p>

        <sql:query var="r_cycles" dataSource = "jdbc/ccs">
            select * from ccs_Release_Cycle where released = 0 order by date desc
        </sql:query>

        <table border="0" class="table table-striped">
            <tr>
                <th>Release Cycle</th>
                <th>Description</th>
                <th>Release Date</th>
                <th>Links</th>
            </tr>     
            <c:forEach var="rel_cycle" items="${r_cycles.rows}">
                <tr>
                    <td><c:if test="${rel_cycle.active == 1}"><font style="color: red"></c:if>${rel_cycle.name}<c:if test="${rel_cycle.active == 1}"></font></c:if></td>
                    <td>${rel_cycle.description}</td>
                    <td>${rel_cycle.date}</td>
                    <td><a href="releaseCyclesAdmin.jsp?complete=${rel_cycle.name}">Mark As Complete</a>
                        <c:if test="${rel_cycle.active == 0}"> | <a href="releaseCyclesAdmin.jsp?activate=${rel_cycle.name}">Activate</a> </c:if>
                        <c:if test="${rel_cycle.active == 1}"> | <a href="releaseCyclesAdmin.jsp?deactivate=${rel_cycle.name}">Deactivate</a> </c:if>
                        <c:if test="${rel_cycle.isToolkit == 1}"> | <a href="releaseCyclesEdit.jsp?edit=${rel_cycle.name}">Edit</a> </c:if>
                        </td>
                    </tr>     
            </c:forEach>
        </table>

        <br>

        <h4>New Release Cycles</h4>
        <p>
            Create a new Release Cycle with the following form.
        </p>
        <form>
            <table border="0" class="table table-striped">
                <tr>
                    <th>Field</th>
                    <th>Value</th>
                    <th>Description</th>
                </tr>     
                <tr>
                    <td>Name</td>
                    <td><input type="text" name="relCycleName"/></td>
                    <td>The name of the new Release Cycle</td>
                </tr>     
                <tr>
                    <td>Description</td>
                    <td><input type="text" name="relCycleDescription"/></td>
                    <td>The description of the new Release Cycle</td>
                </tr>     
                <tr>
                    <td>Target Date: </td>
                    <td><time:dateTimePicker value="${time:now('PST')}" showtime="false" size="18" name="relCycleTargetDate"  timezone="PST" shownone="true" format="%Y-%m-%d" /></td>
                    <td>The target release date</td>
                </tr>     
                <tr>
                    <td>Is Toolkit Release: </td>
                    <td><input type="checkbox" name="isToolkit"/></td>
                    <td>Check if it's a Toolkit Release Cycle</td>
                </tr>     
                <tr>
                    <td colspan="2"><input type="submit" name="createNewRelCycle" value="Create New Release Cycle"/></td>
                </tr>     
            </table>
        </form>


        <br>


    </body>
</html>
